<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\User\Update\Request\Version4;

use Sso\WebserviceBundle\Api\ApiManagerInterface;
use Sso\WebserviceBundle\Services\User\Update\RequestData\Factory as RequestDataFactory;
use Symfony\Component\Validator\Validator\ValidatorInterface;

/**
 * Class Factory
 *
 * @copyright   2018 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 * @package     Sso\WebserviceBundle\Services\User\Show\Request\Version4
 */
final class Factory
{
    /**
     * @var ApiManagerInterface
     */
    private $apiM;

    /**
     * @var RequestDataFactory;
     */
    private $requestDataFactory;

    /**
     * @var ValidatorInterface
     */
    private $validator;
    /**
     * @var \Sso\WebserviceBundle\ErrorHandler\Manager
     */
    private $errorHandler;

    /**
     * Factory constructor.
     *
     * @param ApiManagerInterface $apiM
     * @param RequestDataFactory $requestDataFactory
     */
    public function __construct(ApiManagerInterface $apiM, RequestDataFactory $requestDataFactory)
    {
        $this->apiM = $apiM;
        $this->requestDataFactory = $requestDataFactory;
        $this->errorHandler = $this->apiM->errorHandler();
        $this->validator = $this->apiM->validator();
    }

    /**
     * @return RequestParser
     */
    public function requestParser()
    {
        return new RequestParser($this->apiM->customSerializer(), $this->requestDataFactory, $this->errorHandler, $this->validator, $this->apiM->mapper());
    }
}
