<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2016 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\User\Update\RequestData;

/**
 * Class UpdateData
 *
 * @copyright   2016 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 * @package     Sso\WebserviceBundle\Services\User\Show\RequestData
 */
class UpdateData
{
    const BOOLEAN_TRUE = true;
    const BOOLEAN_FALSE = false;

    /**
     * @var string|null
     */
    private $email = null;

    /**
     * @var string
     */
    private $username = null;

    /**
     * @var string
     */
    private $firstname = null;

    /**
     * @var string
     */
    private $lastname = null;

    /**
     * @var boolean
     */
    private $active = null;

    /**
     * @var boolean
     */
    private $deleted = null;

    /**
     * @var string
     */
    private $authId = null;

    /**
     * @var string
     */
    private $ldapSearchAttributes = null;

    /**
     * @var string
     */
    private $ldapSearchValue = null;

    /**
     * @var boolean
     */
    private $mfaEnabled = null;

    /**
     * @var boolean
     */
    private $mfaRecreate = null;

    /**
     * @var boolean
     */
    protected $activateTokenRecreate;

    /**
     * @var string
     */
    private $password;

    /**
     * @var string
     */
    private $passwordPolicy;

    /**
     * @var \DateTime
     */
    private $lastPasswordChange;

    /**
     * @var boolean
     */
    private $passwordExpired;

    /**
     * @var string|null
     */
    private $passwordEncryptType;

    /**
     * @var array|string[]|null
     */
    private $userGroups;

    /**
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * @param string|null $email
     * @return UpdateData
     */
    public function setEmail($email)
    {
        $this->email = $email;

        return $this;
    }

    /**
     * @return string
     */
    public function getUsername()
    {
        return $this->username;
    }

    /**
     * @param string $username
     * @return UpdateData
     */
    public function setUsername($username)
    {
        $this->username = $username;

        return $this;
    }

    /**
     * @return string
     */
    public function getFirstname()
    {
        return $this->firstname;
    }

    /**
     * @param string $firstname
     * @return UpdateData
     */
    public function setFirstname($firstname)
    {
        $this->firstname = $firstname;

        return $this;
    }

    /**
     * @return string
     */
    public function getLastname()
    {
        return $this->lastname;
    }

    /**
     * @param string $lastname
     * @return UpdateData
     */
    public function setLastname($lastname)
    {
        $this->lastname = $lastname;

        return $this;
    }

    /**
     * @return boolean
     */
    public function isActive()
    {
        return $this->active;
    }

    /**
     * @param boolean $active
     * @return UpdateData
     */
    public function setActive($active)
    {
        if(null !== $active){
            $this->active = $active == 1 ? static::BOOLEAN_TRUE : static::BOOLEAN_FALSE;
        } else {
            $this->active = null;
        }


        return $this;
    }

    /**
     * @return string
     */
    public function getAuthId()
    {
        return $this->authId;
    }

    /**
     * @param string $authId
     * @return UpdateData
     */
    public function setAuthId($authId)
    {
        $this->authId = $authId;

        return $this;
    }

    /**
     * @return string
     */
    public function getLdapSearchAttributes()
    {
        return $this->ldapSearchAttributes;
    }

    /**
     * @param string $ldapSearchAttributes
     * @return UpdateData
     */
    public function setLdapSearchAttributes($ldapSearchAttributes)
    {
        $this->ldapSearchAttributes = $ldapSearchAttributes;

        return $this;
    }

    /**
     * @return string
     */
    public function getLdapSearchValue()
    {
        return $this->ldapSearchValue;
    }

    /**
     * @param string $ldapSearchValue
     * @return UpdateData
     */
    public function setLdapSearchValue($ldapSearchValue)
    {
        $this->ldapSearchValue = $ldapSearchValue;

        return $this;
    }

    /**
     * @return boolean
     */
    public function isMfaEnabled()
    {
        return $this->mfaEnabled;
    }

    /**
     * @param int $mfaEnabled
     * @return UpdateData
     */
    public function setMfaEnabled($mfaEnabled)
    {
        if(null !== $mfaEnabled){
            $this->mfaEnabled = $mfaEnabled == 1 ? static::BOOLEAN_TRUE : static::BOOLEAN_FALSE;
        } else {
            $this->mfaEnabled = null;
        }

        return $this;
    }

    /**
     * @return boolean
     */
    public function isMfaRecreate()
    {
        return $this->mfaRecreate;
    }

    /**
     * @param int $mfaRecreate
     * @return UpdateData
     */
    public function setMfaRecreate($mfaRecreate)
    {
        if(null !== $mfaRecreate){
            $this->mfaRecreate = $mfaRecreate == 1 ? static::BOOLEAN_TRUE : static::BOOLEAN_FALSE;
        } else {
            $this->mfaRecreate = null;
        }


        return $this;
    }

    /**
     * @return bool
     */
    public function isActivateTokenRecreate()
    {
        return $this->activateTokenRecreate;
    }

    /**
     * @param bool $activateTokenRecreate
     */
    public function setActivateTokenRecreate($activateTokenRecreate)
    {
        $this->activateTokenRecreate = $activateTokenRecreate ? true : null;
    }

    /**
     * @return boolean
     */
    public function isDeleted()
    {
        return $this->deleted;
    }

    /**
     * @param boolean $deleted
     * @return UpdateData
     */
    public function setDeleted($deleted)
    {
        if(null !== $deleted){
            $this->deleted = $deleted ? static::BOOLEAN_TRUE : static::BOOLEAN_FALSE;
        } else {
            $this->deleted = null;
        }

        return $this;
    }

    /**
     * @return string
     */
    public function getPassword()
    {
        return $this->password;
    }

    /**
     * @param string $password
     * @return UpdateData
     */
    public function setPassword($password)
    {
        $this->password = $password;
        return $this;
    }

    /**
     * @return string
     */
    public function getPasswordPolicy()
    {
        return $this->passwordPolicy;
    }

    /**
     * @param string $passwordPolicy
     * @return UpdateData
     */
    public function setPasswordPolicy($passwordPolicy)
    {
        $this->passwordPolicy = $passwordPolicy;
        return $this;
    }

    /**
     * @return \DateTime|null
     */
    public function getLastPasswordChange()
    {
        return $this->lastPasswordChange;
    }

    /**
     * @param \DateTime|null $lastPasswordChange
     * @return UpdateData
     */
    public function setLastPasswordChange($lastPasswordChange)
    {
        $this->lastPasswordChange = $lastPasswordChange instanceof \DateTime ? clone $lastPasswordChange : null;
        return $this;
    }

    /**
     * @return bool
     */
    public function isPasswordExpired()
    {
        return $this->passwordExpired;
    }

    /**
     * @param bool $passwordExpired
     * @return UpdateData
     */
    public function setPasswordExpired($passwordExpired)
    {
        $this->passwordExpired = $passwordExpired;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getPasswordEncryptType(): ?string
    {
        return $this->passwordEncryptType;
    }

    /**
     * @param string|null $passwordEncryptType
     */
    public function setPasswordEncryptType(?string $passwordEncryptType): void
    {
        $this->passwordEncryptType = $passwordEncryptType;
    }

    /**
     * @return array|string[]|null
     */
    public function getUserGroups()
    {
        return $this->userGroups;
    }

    /**
     * @param array|string[]|null $userGroups
     */
    public function setUserGroups($userGroups): void
    {
        $this->userGroups = $userGroups;
    }
}
