<?php

/**
 * Class Update
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\User\Update\Response\Version5;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Update
 * @package Sso\WebserviceBundle\Services\User\Update\Response\Version5
 */
final class Update
{
    /**
     * @Serializer\SerializedName("Status")
     * @Serializer\Type("string")
     * @var string
     */
    private $status;

    /**
     * @Serializer\SerializedName("UserType")
     * @Serializer\Type("Sso\WebserviceBundle\Services\User\Update\Response\Version5\UserType")
     * @var UserType
     */
    private $userType;

    /**
     * @param string $status
     * @return Update
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * @param UserType $userType
     * @return Update
     */
    public function setUserType($userType)
    {
        $this->userType = $userType;

        return $this;
    }
}
