<?php

/**
 * Class UserType
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\User\Update\Response\Version5;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class UserType
 * @package Sso\WebserviceBundle\Services\User\Update\Response\Version5
 */
final class UserType
{
    /**
     * @Serializer\SerializedName("Guid")
     * @Serializer\Type("string")
     * @var string
     */
    private $guid;

    /**
     * @Serializer\SerializedName("Username")
     * @Serializer\Type("string")
     * @var string
     */
    private $username;

    /**
     * @Serializer\SerializedName("Email")
     * @Serializer\Type("string")
     * @var string
     */
    private $email;

    /**
     * @Serializer\SerializedName("Firstname")
     * @Serializer\Type("string")
     * @var string
     */
    private $firstname;

    /**
     * @Serializer\SerializedName("Lastname")
     * @Serializer\Type("string")
     * @var string
     */
    private $lastname;

    /**
     * @Serializer\SerializedName("Active")
     * @Serializer\Type("integer")
     * @Serializer\Accessor(getter="getActiveAsInteger")
     * @var boolean
     */
    private $active;

    /**
     * @Serializer\SerializedName("ActivateToken")
     * @Serializer\Type("string")
     * @var string
     */
    private $activateToken;

    /**
     * @Serializer\SerializedName("ActivateTokenExpire")
     * @Serializer\Type("DateTime")
     * @var \DateTime
     */
    private $activateTokenExpire;

    /**
     * @Serializer\SerializedName("Deleted")
     * @Serializer\Type("integer")
     * @Serializer\Accessor(getter="getDeletedAsInteger")
     * @var boolean
     */
    private $deleted;

    /**
     * @Serializer\SerializedName("DeletedAt")
     * @Serializer\Type("DateTime")
     * @var \DateTime
     */
    private $deletedAt;

    /**
     * @Serializer\SerializedName("CreatedAt")
     * @Serializer\Type("DateTime")
     * @var \DateTime
     */
    private $createdAt;

    /**
     * @Serializer\SerializedName("LastLoginAt")
     * @Serializer\Type("DateTime")
     * @var \DateTime
     */
    private $lastLoginAt;

    /**
     * @Serializer\SerializedName("LoginFails")
     * @Serializer\Type("integer")
     * @var integer
     */
    private $loginFails;

    /**
     * @Serializer\SerializedName("UpdatedAt")
     * @Serializer\Type("DateTime")
     * @var \DateTime
     */
    private $updatedAt;

    /**
     * @Serializer\SerializedName("AuthId")
     * @Serializer\Type("string")
     * @var string
     */
    private $authId;

    /**
     * @Serializer\SerializedName("LdapSearchAttributes")
     * @Serializer\Type("string")
     * @var string
     */
    private $ldapSearchAttributes;

    /**
     * @Serializer\SerializedName("LdapSearchValue")
     * @Serializer\Type("string")
     * @var string
     */
    private $ldapSearchValue;

    /**
     * @Serializer\SerializedName("MfaEnabled")
     * @Serializer\Type("integer")
     * @Serializer\Accessor(getter="getMfaEnabledAsInteger")
     * @var boolean
     */
    private $mfaEnabled;


    /**
     * @Serializer\SerializedName("MfaRecreate")
     * @Serializer\Type("integer")
     * @Serializer\Accessor(getter="getMfaRecreateAsInteger")
     * @var boolean
     */
    private $mfaRecreate;

    /**
     * @Serializer\SerializedName("PasswordPolicy")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $passwordPolicy;

    /**
     * @Serializer\SerializedName("LastPasswordChange")
     * @Serializer\Type("DateTime")
     *
     * @var \DateTime|null
     */
    protected $lastPasswordChange;

    /**
     * @Serializer\SerializedName("PasswordExpired")
     * @Serializer\Type("integer")
     *
     * @var integer
     */
    protected $passwordExpired;

    /**
     * @Serializer\SerializedName("PasswordEncryptType")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $passwordEncryptType;

    /**
     * @Serializer\SerializedName("UserGroups")
     * @Serializer\Type("array<string>")
     * @Serializer\XmlList(entry="UserGroup")
     *
     * @var array|string[]|null
     */
    private $userGroups;

    /**
     * @param array $userAttributes
     */
    public function setFromArray(array $userAttributes)
    {
        foreach ($userAttributes as $name => $value) {
            $method = 'set'.ucfirst($name);
            if (!method_exists($this, $method)) {
                throw new \BadMethodCallException(sprintf(
                    'Unable to create user response model %s! Userattribute %s does not exist.',
                    self::class,
                    $name
                ));
            }
            $this->$method($value);
        }
    }

    /**
     * @param string $guid
     * @return UserType
     */
    public function setGuid($guid): void
    {
        $this->guid = $guid;
    }

    /**
     * @param string $username
     * @return UserType
     */
    public function setUsername($username): void
    {
        $this->username = $username;
    }

    /**
     * @param string $email
     * @return UserType
     */
    public function setEmail($email): void
    {
        $this->email = $email;
    }

    /**
     * @param string $firstname
     * @return UserType
     */
    public function setFirstname($firstname): void
    {
        $this->firstname = $firstname;
    }

    /**
     * @param string $lastname
     * @return UserType
     */
    public function setLastname($lastname): void
    {
        $this->lastname = $lastname;
    }

    /**
     * @param boolean $active
     * @return UserType
     */
    public function setActive($active): void
    {
        $this->active = $active;
    }

    /**
     * @return integer
     */
    public function getActiveAsInteger(): int
    {
        return $this->active ? 1 : 0;
    }

    /**
     * @param string $activateToken
     */
    public function setActivateToken($activateToken): void
    {
        $this->activateToken = $activateToken;
    }

    /**
     * @param \DateTime $activateTokenExpire
     */
    public function setActivateTokenExpire(\DateTime $activateTokenExpire = null): void
    {
        $this->activateTokenExpire = $activateTokenExpire;
    }

    /**
     * @param boolean $deleted
     * @return UserType
     */
    public function setDeleted($deleted): void
    {
        $this->deleted = $deleted;
    }

    /**
     * @param \DateTime $deletedAt
     * @return UserType
     */
    public function setDeletedAt($deletedAt = null): void
    {
        $this->deletedAt = $deletedAt;
    }

    /**
     * @return integer
     */
    public function getDeletedAsInteger(): int
    {
        return $this->deleted ? 1 : 0;
    }

    /**
     * @param \DateTime $createdAt
     * @return UserType
     */
    public function setCreatedAt($createdAt): void
    {
        $this->createdAt = $createdAt;
    }

    /**
     * @param \DateTime $lastLoginAt
     * @return UserType
     */
    public function setLastLoginAt($lastLoginAt): void
    {
        $this->lastLoginAt = $lastLoginAt;
    }

    /**
     * @param int $loginFails
     * @return UserType
     */
    public function setLoginFails($loginFails): void
    {
        $this->loginFails = $loginFails;
    }

    /**
     * @param \DateTime $updatedAt
     * @return UserType
     */
    public function setUpdatedAt($updatedAt): void
    {
        $this->updatedAt = $updatedAt;
    }

    /**
     * @param string $authId
     * @return UserType
     */
    public function setAuthId($authId): void
    {
        $this->authId = $authId;
    }

    /**
     * @param string $ldapSearchAttributes
     * @return UserType
     */
    public function setLdapSearchAttributes($ldapSearchAttributes): void
    {
        $this->ldapSearchAttributes = $ldapSearchAttributes;
    }

    /**
     * @param string $ldapSearchValue
     * @return UserType
     */
    public function setLdapSearchValue($ldapSearchValue): void
    {
        $this->ldapSearchValue = $ldapSearchValue;
    }

    /**
     * @param boolean $mfaEnabled
     * @return UserType
     */
    public function setMfaEnabled($mfaEnabled): void
    {
        $this->mfaEnabled = $mfaEnabled;
    }

    /**
     * @return integer
     */
    public function getMfaEnabledAsInteger(): int
    {
        return $this->mfaEnabled ? 1 : 0;
    }

    /**
     * @param boolean $mfaRecreate
     * @return UserType
     */
    public function setMfaRecreate($mfaRecreate): void
    {
        $this->mfaRecreate = $mfaRecreate;
    }

    /**
     * @return integer
     */
    public function getMfaRecreateAsInteger(): int
    {
        return $this->mfaRecreate ? 1 : 0;
    }

    /**
     * @param string $passwordPolicy
     * @return UserType
     */
    public function setPasswordPolicy($passwordPolicy): void
    {
        $this->passwordPolicy = $passwordPolicy;
    }

    /**
     * @param \DateTime|null $lastPasswordChange
     * @return UserType
     */
    public function setLastPasswordChange($lastPasswordChange): void
    {
        $this->lastPasswordChange = $lastPasswordChange instanceof \DateTime ? clone $lastPasswordChange : null;
    }

    /**
     * @param int $passwordExpired
     * @return UserType
     */
    public function setPasswordExpired($passwordExpired): void
    {
        $this->passwordExpired = $passwordExpired;
    }

    /**
     * @param string $passwordEncryptType
     */
    public function setPasswordEncryptType(string $passwordEncryptType): void
    {
        $this->passwordEncryptType = $passwordEncryptType;
    }

    /**
     * @param array|string[]|null $userGroups
     */
    public function setUserGroups($userGroups): void
    {
        $this->userGroups = $userGroups;
    }
}
