<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\UserApplication\Delete\Request\Version2;

use Symfony\Component\Validator\Constraints as Assert;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class ApplicationType
 *
 * @Serializer\XmlRoot("ApplicationType")
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\WebserviceBundle\Services\UserApplication\Delete\Request\Version2
 */
final class ApplicationType
{
    /**
     * @Assert\Regex(
     *     pattern="/(0|1)/",
     *     match=true,
     *     message="Force flag must be 0 or 1"
     * )
     * @Serializer\SerializedName("Force")
     * @Serializer\Type("integer")
     * @var integer
     */
    private $force;

    /**
     * @Assert\NotBlank()
     * @Serializer\SerializedName("Name")
     * @Serializer\Type("string")
     * @var string
     */
    private $name;

    /**
     * @return int
     */
    public function getForce()
    {
        return $this->force;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
}
