<?php

/**
 * Class Delete
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\UserApplication\Delete\Response\Version2;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class Delete
 * @package Sso\WebserviceBundle\Services\UserApplication\Delete\Response\Version2
 */
final class Delete
{
    /**
     * @Serializer\SerializedName("Status")
     * @Serializer\Type("string")
     * @var string
     */
    private $status;

    /**
     * @Serializer\SerializedName("Message")
     * @Serializer\Type("string")
     * @var string
     */
    private $message;

    /**
     * @param string $status
     * @return Delete
     */
    public function setStatus($status)
    {
        $this->status = $status;
        return $this;
    }

    /**
     * @param string $message
     * @return Delete
     */
    public function setMessage($message)
    {
        $this->message = $message;
        return $this;
    }
}
