<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\UserApplication\Show\ResponseData;

use Sso\WebserviceBundle\Entity\Webservice\Type\User as UserModel;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * Class User
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\WebserviceBundle\Services\UserApplication\Show\ResponseData
 */
final class User
{
    /**
     * @var string
     */
    private $guid;

    /**
     * @var string
     */
    private $email;

    /**
     * @var string
     */
    private $username;

    /**
     * @var string
     */
    private $firstname;

    /**
     * @var string
     */
    private $lastname;

    /**
     * @var boolean
     */
    private $active;

    /**
     * @var string
     */
    private $authId;

    /**
     * @var string
     */
    private $ldapSearchAttributes;

    /**
     * @var string
     */
    private $ldapSearchValue;

    /**
     * @var boolean
     */
    private $deleted;

    /**
     * @var \DateTime
     */
    private $deletedAt;

    /**
     * @var \DateTime
     */
    private $createdAt;

    /**
     * @var \DateTime
     */
    private $updatedAt;

    /**
     * @var \DateTime
     */
    private $updatedReferencesAt;

    /**
     * @var \DateTime
     */
    private $lastLoginAt;

    /**
     * @var boolean
     */
    private $mfaEnabled;

    /**
     * @var string
     */
    private $mfaSecret;

    /**
     * Mfa secret create date
     *
     * @var \DateTime
     */
    private $mfaCreatedAt;

    /**
     * Mfa secret update date
     *
     * @var \DateTime
     */
    private $mfaUpdatedAt;

    /**
     * @var integer
     */
    private $loginFails;

    /**
     * @var ApplicationType[]
     */
    private $applicationType;


    private $requestMapper = [
        'getGuid' => 'setGuid',
        'getEmail' => 'setEmail',
        'getUsername' => 'setUsername',
        'getFirstname' => 'setFirstname',
        'getLastname' => 'setLastname',
        'getActive' => 'setActive',
        'getAuthId' => 'setAuthId',
        'getLdapSearchAttributes' => 'setLdapSearchAttributes',
        'getLdapSearchValue' => 'setLdapSearchValue',
        'isDeleted' => 'setDeleted',
        'getCreatedAt' => 'setCreatedAt',
        'getUpdatedAt' => 'setUpdatedAt',
        'getLastLoginAt' => 'setLastLoginAt',
        'isMfaEnabled' => 'setMfaEnabled',
    ];

    public function __construct()
    {
        $this->applicationType = new ArrayCollection();
    }

    /**
     * @param UserModel $userModel
     * @param bool|null $activeApplication
     * @return User
     */
    public function setFromUserModel(UserModel $userModel, $activeApplication = false)
    {

        $responseData = new self();
        foreach ($this->requestMapper as $getter => $setter) {
            if (method_exists($userModel, $getter) && method_exists($responseData, $setter)) {
                $responseData->$setter($userModel->$getter());
            }
        }

        if (true === $activeApplication) {
            //now we have to add the userApplications
            foreach ($userModel->getUserApplications() as $userApplicationDb) {
                if($userApplicationDb->getActive()){
                    $userApplication = new ApplicationType();
                    $userApplication->setActive($userApplicationDb->getActive());
                    $userApplication->setName($userApplicationDb->getName());
                    $responseData->addApplicationType($userApplication);
                }

            }

        } elseif (false === $activeApplication){
            foreach ($userModel->getUserApplications() as $userApplicationDb) {
                if(false === $userApplicationDb->getActive()){
                    $userApplication = new ApplicationType();
                    $userApplication->setActive($userApplicationDb->getActive());
                    $userApplication->setName($userApplicationDb->getName());
                    $responseData->addApplicationType($userApplication);
                }
            }
        } else {
            //show all

            foreach ($userModel->getUserApplications() as $userApplicationDb) {
                $userApplication = new ApplicationType();
                $userApplication->setActive($userApplicationDb->getActive());
                $userApplication->setName($userApplicationDb->getName());
                $responseData->addApplicationType($userApplication);
            }
        }

        return $responseData;
    }

    /**
     * @return string
     */
    public function getGuid()
    {
        return $this->guid;
    }

    /**
     * @param string $guid
     */
    public function setGuid($guid)
    {
        $this->guid = (string)$guid;
    }

    /**
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * @param string $email
     */
    public function setEmail($email)
    {
        $this->email = (string)$email;
    }

    /**
     * @return string
     */
    public function getUsername()
    {
        return $this->username;
    }

    /**
     * @param string $username
     */
    public function setUsername($username)
    {
        $this->username = (string)$username;
    }

    /**
     * @return string
     */
    public function getFirstname()
    {
        return $this->firstname;
    }

    /**
     * @param string $firstname
     */
    public function setFirstname($firstname)
    {
        $this->firstname = (string)$firstname;
    }

    /**
     * @return string
     */
    public function getLastname()
    {
        return $this->lastname;
    }

    /**
     * @param string $lastname
     */
    public function setLastname($lastname)
    {
        $this->lastname = (string)$lastname;
    }

    /**
     * @return boolean
     */
    public function isActive()
    {
        return $this->active;
    }

    /**
     * @param boolean $active
     */
    public function setActive($active)
    {
        $this->active = (boolean)$active;
    }

    /**
     * @return string
     */
    public function getAuthId()
    {
        return $this->authId;
    }

    /**
     * @param string $authId
     */
    public function setAuthId($authId)
    {
        $this->authId = (string)$authId;
    }

    /**
     * @return string
     */
    public function getLdapSearchAttributes()
    {
        return $this->ldapSearchAttributes;
    }

    /**
     * @param string $ldapSearchAttributes
     */
    public function setLdapSearchAttributes($ldapSearchAttributes)
    {
        $this->ldapSearchAttributes = (string)$ldapSearchAttributes;
    }

    /**
     * @return string
     */
    public function getLdapSearchValue()
    {
        return $this->ldapSearchValue;
    }

    /**
     * @param string $ldapSearchValue
     */
    public function setLdapSearchValue($ldapSearchValue)
    {
        $this->ldapSearchValue = (string)$ldapSearchValue;
    }

    /**
     * @return boolean
     */
    public function isDeleted()
    {
        return $this->deleted;
    }

    /**
     * @param boolean $deleted
     */
    public function setDeleted($deleted)
    {
        $this->deleted = (boolean)$deleted;
    }

    /**
     * @return \DateTime
     */
    public function getDeletedAt()
    {
        return $this->deletedAt;
    }

    /**
     * @param \DateTime $deletedAt
     */
    public function setDeletedAt(\DateTime $deletedAt = null)
    {
        $this->deletedAt = $deletedAt;
    }

    /**
     * @return \DateTime
     */
    public function getCreatedAt()
    {
        return $this->createdAt;
    }

    /**
     * @param \DateTime $createdAt
     */
    public function setCreatedAt(\DateTime $createdAt = null)
    {
        $this->createdAt = $createdAt;
    }

    /**
     * @return \DateTime
     */
    public function getUpdatedAt()
    {
        return $this->updatedAt;
    }

    /**
     * @param \DateTime $updatedAt
     */
    public function setUpdatedAt(\DateTime $updatedAt = null)
    {
        $this->updatedAt = $updatedAt;
    }

    /**
     * @return \DateTime
     */
    public function getUpdatedReferencesAt()
    {
        return $this->updatedReferencesAt;
    }

    /**
     * @param \DateTime $updatedReferencesAt
     */
    public function setUpdatedReferencesAt(\DateTime $updatedReferencesAt = null)
    {
        $this->updatedReferencesAt = $updatedReferencesAt;
    }

    /**
     * @return \DateTime
     */
    public function getLastLoginAt()
    {
        return $this->lastLoginAt;
    }

    /**
     * @param \DateTime $lastLoginAt
     */
    public function setLastLoginAt(\DateTime $lastLoginAt = null)
    {
        $this->lastLoginAt = $lastLoginAt;
    }

    /**
     * @return boolean
     */
    public function isMfaEnabled()
    {
        return $this->mfaEnabled;
    }

    /**
     * @param boolean $mfaEnabled
     */
    public function setMfaEnabled($mfaEnabled)
    {
        $this->mfaEnabled = (boolean)$mfaEnabled;
    }

    /**
     * @return string
     */
    public function getMfaSecret()
    {
        return $this->mfaSecret;
    }

    /**
     * @param string $mfaSecret
     */
    public function setMfaSecret($mfaSecret)
    {
        $this->mfaSecret = (string)$mfaSecret;
    }

    /**
     * @return \DateTime
     */
    public function getMfaCreatedAt()
    {
        return $this->mfaCreatedAt;
    }

    /**
     * @param \DateTime $mfaCreatedAt
     */
    public function setMfaCreatedAt(\DateTime $mfaCreatedAt)
    {
        $this->mfaCreatedAt = $mfaCreatedAt;
    }

    /**
     * @return \DateTime
     */
    public function getMfaUpdatedAt()
    {
        return $this->mfaUpdatedAt;
    }

    /**
     * @param \DateTime $mfaUpdatedAt
     */
    public function setMfaUpdatedAt(\DateTime $mfaUpdatedAt = null)
    {
        $this->mfaUpdatedAt = $mfaUpdatedAt;
    }

    /**
     * @return int
     */
    public function getLoginFails()
    {
        return $this->loginFails;
    }

    /**
     * @param int $loginFails
     */
    public function setLoginFails($loginFails)
    {
        $this->loginFails = (int)$loginFails;
    }

    /**
     * @return ApplicationType[]
     */
    public function getApplicationType()
    {
        return $this->applicationType;
    }

    /**
     * @param ApplicationType[] $applicationType
     */
    public function addApplicationType(ApplicationType $applicationType)
    {
        $this->applicationType->add($applicationType);
    }
}
