<?php

/**
 * Class UserType
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\UserApplication\ShowDetails\Request\Version2;

use Symfony\Component\Validator\Constraints as Assert;
use JMS\Serializer\Annotation as Serializer;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * Class UserType
 *
 * @Serializer\XmlRoot("ApplicationType")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\WebserviceBundle\Services\UserApplication\ShowDetails\Request\Version2
 */
final class ApplicationType
{
    /**
     * 
     * @Serializer\SerializedName("Name")
     * @Serializer\Type("ArrayCollection<string>")
     * @Serializer\XmlList(inline = true, entry = "Name")
     * @var ArrayCollection
     */
    private $names;

    /**
     * @return ArrayCollection
     */
    public function getNames()
    {
        return $this->names;
    }
}
