<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\UserApplication\ShowDetails\Request\Version3;

use Symfony\Component\Validator\Constraints as Assert;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class Key
 *
 * @Serializer\XmlRoot("Key")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\WebserviceBundle\Services\ShowDetails\UserApplication\Request\Version3;
 */
final class Key
{

    /**
     * @Assert\NotBlank()
     * @Assert\Valid
     *
     * @Serializer\SerializedName("UserType")
     * @Serializer\Type("Sso\WebserviceBundle\Services\UserApplication\ShowDetails\Request\Version3\UserType")
     * @var UserType
     */
    private $userType;

    /**
     *
     * @Serializer\SerializedName("ApplicationType")
     * @Serializer\Type("Sso\WebserviceBundle\Services\UserApplication\ShowDetails\Request\Version3\ApplicationType")
     * @var ApplicationType
     */
    private $applicationType;

    /**
     * @return UserType
     */
    public function getUserType()
    {
        return $this->userType;
    }

    /**
     * @return ApplicationType
     */
    public function getApplicationType()
    {
        return $this->applicationType;
    }
}
