<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\UserApplication\ShowDetails\Response\Version3;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class User
 * @package Sso\WebserviceBundle\Services\UserApplication\ShowDetails\Response\Version3
 */
final class UserApplication
{
    /**
     * @Serializer\SerializedName("Show")
     * @Serializer\Type("array<Sso\WebserviceBundle\Services\UserApplication\ShowDetails\Response\Version3\ShowDetails>")
     * @Serializer\XmlList(inline=true, entry="ShowDetails")
     * @var ShowDetails[]
     */
    private $show = array();

    /**
     * @param ShowDetails $show
     */
    public function addShow(ShowDetails $show)
    {
        $this->show[] = $show;
    }
}
