<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\UserApplicationAttribute\Add\Request;

/**
 * Interface UserTypeInterface
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\WebserviceBundle\Services\UserApplicationAttribute\Add\Request
 */
interface UserTypeInterface
{
    /**
     * @return string
     */
    public function getIdentifier(): string;

    /**
     * @return bool
     */
    public function hasIdentifier(): bool;

    /**
     * @return string
     */
    public function getUsername(): string;

    /**
     * @return bool
     */
    public function hasUsername(): bool;

    /**
     * @return string
     */
    public function getGuid(): string;

    /**
     * @return bool
     */
    public function hasGuid(): bool;

    /**
     * @return string
     */
    public function getEmail(): string;

    /**
     * @return bool
     */
    public function hasEmail(): bool;
}
