<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\UserApplicationAttribute\Add\Request\Version2;

use Symfony\Component\Validator\Constraints as Assert;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class Key
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\WebserviceBundle\Services\UserApplicationAttribute\Add\Request\Version2
 */
class Key
{
    /**
     * @Assert\NotNull()
     * @Assert\Valid
     *
     * @Serializer\SerializedName("UserType")
     * @Serializer\Type("Sso\WebserviceBundle\Services\UserApplicationAttribute\Add\Request\Version2\UserType")
     *
     * @var UserType
     */
    private $userType;

    /**
     * @Assert\NotNull()
     * @Assert\Valid
     *
     * @Serializer\SerializedName("ApplicationType")
     * @Serializer\Type("Sso\WebserviceBundle\Services\UserApplicationAttribute\Add\Request\Version2\ApplicationType")
     *
     * @var ApplicationType
     */
    private $applicationType;

    /**
     * @return UserType
     */
    public function getUserType(): UserType
    {
        return $this->userType;
    }

    /**
     * @return ApplicationType
     */
    public function getApplicationType(): ApplicationType
    {
        return $this->applicationType;
    }
}
