<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\UserApplicationAttribute\Add\Request\Version2;

use Symfony\Component\Validator\Constraints as Assert;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class UserApplicationAttribute
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\WebserviceBundle\Services\UserApplicationAttribute\Add\Request\Version2
 */
class UserApplicationAttribute
{
    /**
     * @Assert\NotNull()
     * @Assert\Valid
     *
     * @Serializer\SerializedName("Add")
     * @Serializer\Type("Sso\WebserviceBundle\Services\UserApplicationAttribute\Add\Request\Version2\Add")
     *
     * @var Add
     */
    private $add;

    /**
     * @return Add
     */
    public function getAdd(): Add
    {
        return $this->add;
    }
}
