<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\UserApplicationAttribute\Add\Response;

use Sso\WebserviceBundle\Services\ApiVersionInflectorInterface;
use Sso\WebserviceBundle\Services\UserApplicationAttribute\Add\ResponseBuilderInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Class ResponseBuilderFactory
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\WebserviceBundle\Services\UserApplicationAttribute\Add\Response
 */
class ResponseBuilderFactory
{
    /**
     * @var ContainerInterface
     */
    private $container;

    /**
     * @var ApiVersionInflectorInterface
     */
    private $versionInflector;

    /**
     * ResponseBuilderFactory constructor.
     * @param ContainerInterface $container
     * @param ApiVersionInflectorInterface $versionInflector
     */
    public function __construct(ContainerInterface $container, ApiVersionInflectorInterface $versionInflector)
    {
        $this->container = $container;
        $this->versionInflector = $versionInflector;
    }

    /**
     * @return ResponseBuilderInterface
     */
    public function createResponseBuilder()
    {
        $serviceId = $this->versionInflector->inflectService(
            'sso_webservice.services_user_application_attribute_add_response',
            'response_builder'
        );

        try {
            $responseBuilder = $this->container->get($serviceId);
        } catch (\Exception $e) {
            throw new \InvalidArgumentException(
                'Service ' . $serviceId . ' does not exist!'
            );
        }

        if (!$responseBuilder instanceof ResponseBuilderInterface) {
            throw new \InvalidArgumentException(
                'Service ' . $serviceId . ' does not implement ' . ResponseBuilderInterface::class . '!'
            );
        }

        return $responseBuilder;
    }
}
