<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\UserApplicationAttribute\Add\Response\Version2;

use Sso\WebserviceBundle\ErrorHandler\Response\ErrorsInterface;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class Response
 *
 * @Serializer\XmlRoot("SsoResponse")
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\WebserviceBundle\Services\UserApplicationAttribute\Add\Response\Version2
 */
class Response
{
    /**
     * @Serializer\SerializedName("Code")
     * @Serializer\Type("integer")
     *
     * @var string
     */
    private $code;

    /**
     * @Serializer\SerializedName("Status")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $status;

    /**
     * @Serializer\SerializedName("Trackid")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $trackid;

    /**
     * @Serializer\SerializedName("Date")
     * @Serializer\Type("DateTime")
     *
     * @var \DateTime
     */
    private $date;

    /**
     * @Serializer\SerializedName("ScriptTimeSec")
     * @Serializer\Type("double")
     *
     * @var double
     */
    private $scriptTimeSec;

    /**
     * @Serializer\SerializedName("UserApplicationAttribute")
     * @Serializer\Type("Sso\WebserviceBundle\Services\UserApplicationAttribute\Add\Response\Version2\UserApplicationAttribute")
     *
     * @var UserApplicationAttribute
     */
    private $userApplicationAttribute;

    /**
     * @Serializer\XmlList(inline = true)
     * @var ErrorsInterface
     */
    private $errors;

    /**
     * @param string $code
     */
    public function setCode(string $code): void
    {
        $this->code = $code;
    }

    /**
     * @param string $status
     */
    public function setStatus(string $status): void
    {
        $this->status = $status;
    }

    /**
     * @param string $trackid
     */
    public function setTrackid(string $trackid): void
    {
        $this->trackid = $trackid;
    }

    /**
     * @param \DateTime $date
     */
    public function setDate(\DateTime $date): void
    {
        $this->date = $date;
    }

    /**
     * @param float $scriptTimeSec
     */
    public function setScriptTimeSec(float $scriptTimeSec): void
    {
        $this->scriptTimeSec = $scriptTimeSec;
    }

    /**
     * @param UserApplicationAttribute $userApplicationAttribute
     */
    public function setUserApplicationAttribute(UserApplicationAttribute $userApplicationAttribute): void
    {
        $this->userApplicationAttribute = $userApplicationAttribute;
    }

    /**
     * @param ErrorsInterface $errors
     */
    public function setErrors($errors): void
    {
        $this->errors = $errors;
    }
}
