<?php

/**
 * Class User
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\UserApplicationAttribute\Show\Response\Version2;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class User
 * @package Sso\WebserviceBundle\Services\UserApplicationAttribute\Show\Response\Version2
 */
final class UserApplicationAttribute
{
    /**
     * @Serializer\SerializedName("Show")
     * @Serializer\Type("array<Sso\WebserviceBundle\Services\UserApplicationAttribute\Show\Response\Version2\Show>")
     * @Serializer\XmlList(inline=true, entry="Show")
     * @var Show[]
     */
    private $show = array();

    /**
     * @param Show $show
     */
    public function addShow(Show $show)
    {
        $this->show[] = $show;
    }
}
