<?php

/**
 * Class UserType
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\UserApplicationRole\Show\Response\Version2;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class UserType
 * @package Sso\WebserviceBundle\Services\UserApplicationRole\Show\Response\Version2
 */
final class ApplicationType
{
    /**
     * @Serializer\SerializedName("Name")
     * @Serializer\Type("string")
     * @var string
     */
    private $name;

    /**
     * @Serializer\SerializedName("Active")
     * @Serializer\Type("integer")
     * @var integer
     */
    private $active;
    /**
     * @Serializer\SerializedName("RoleType")
     * @Serializer\Type("ArrayCollection<Sso\WebserviceBundle\Services\UserApplicationRole\Show\Response\Version2\RoleType>")
     * @Serializer\XmlList(inline=true, entry="RoleType")
     * @var RoleType[]
     */
    private $roleType;


    /**
     * ApplicationType constructor.
     */
    public function __construct()
    {
        $this->roleType = new ArrayCollection();

    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return ApplicationType
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @return boolean
     */
    public function isActive()
    {
        return $this->active;
    }

    /**
     * @param boolean $active
     * @return ApplicationType
     */
    public function setActive($active)
    {
        $this->active = $active ? 1 : 0;

        return $this;
    }

    /**
     * @param RoleType[] $roleType
     */
    public function addRoleType(RoleType $roleType)
    {
        $this->roleType->add($roleType);
    }
}
