<?php

/**
 * Class Show
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\UserApplicationRole\Show\Response\Version2;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class Show
 * @package Sso\WebserviceBundle\Services\UserApplicationRole\Show\Response\Version2
 */
final class Show
{
    /**
     * @Serializer\SerializedName("Status")
     * @Serializer\Type("string")
     * @var string
     */
    private $status;

    /**
     * @Serializer\SerializedName("UserType")
     * @Serializer\Type("Sso\WebserviceBundle\Services\UserApplicationRole\Show\Response\Version2\UserType")
     * @var UserType
     */
    private $userType;

    /**
     * @Serializer\SerializedName("ApplicationType")
     * @Serializer\Type("ArrayCollection<Sso\WebserviceBundle\Services\UserApplicationRole\Show\Response\Version2\ApplicationType>")
     * @Serializer\XmlList(inline = true, entry = "ApplicationType")
     * @var ApplicationType[]
     */
    private $applicationType;


    public function __construct()
    {
        $this->applicationType = new ArrayCollection();
    }

    /**
     * @param string $status
     * @return Show
     */
    public function setStatus($status)
    {
        $this->status = $status;
        return $this;
    }

    /**
     * @param UserType $userType
     * @return Show
     */
    public function setUserType($userType)
    {
        $this->userType = $userType;
        return $this;
    }

    /**
     * @param ApplicationType $applicationType
     * @return Show
     */
    public function addApplicationType(ApplicationType $applicationType)
    {
        $this->applicationType->add($applicationType);

        return $this;
    }
}
