<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\UserGroup\Add\Request\Version2;

use Symfony\Component\Validator\Constraints as Assert;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class Value
 *
 * @Serializer\XmlRoot("Value")
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\WebserviceBundle\Services\UserGroup\Add\Request\Version2;
 */
class Value
{

    /**
     * @Assert\NotBlank()
     * @Assert\Valid
     *
     * @Serializer\SerializedName("UserGroupType")
     * @Serializer\Type("Sso\WebserviceBundle\Services\UserGroup\Add\Request\Version2\UserGroupType")
     * @var UserGroupType
     */
    private $userGroupType;

    /**
     * @return UserGroupType
     */
    public function getUserGroupType()
    {
        return $this->userGroupType;
    }
}
