<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\UserGroup\Search\Response\Version2;

use Sso\WebserviceBundle\Api\ApiManagerInterface;

/**
 * Class Factory
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\WebserviceBundle\Services\UserGroup\Search\Response\Version2
 */
final class Factory
{
    /**
     * @var ApiManagerInterface
     */
    private $apiM;

    /**
     * Factory constructor.
     * @param ApiManagerInterface $apiM
     */
    public function __construct(ApiManagerInterface $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     * @return Response
     */
    public function response()
    {
        return new Response();
    }

    /**
     * @return Search
     */
    public function search()
    {
        return new Search();
    }

    /**
     * @return UserGroup
     */
    public function userGroup()
    {
        return new UserGroup();
    }

    /**
     * @return UserGroupType
     */
    public function userGroupType()
    {
        return new UserGroupType();
    }

    /**
     * @return double
     */
    public function scriptTimeSeconds(){
        return $this->apiM->scriptTimeSeconds();
    }
}
