<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\UserGroup\Search\Response\Version2;

use JMS\Serializer\Annotation as Serializer;
use Sso\WebserviceBundle\ErrorHandler\Response\ErrorsObjectInterface;

/**
 * Class Search
 * @package Sso\WebserviceBundle\Services\UserGroup\Search\Response\Version2
 */
final class Search
{
    /**
     * @Serializer\SerializedName("Status")
     * @Serializer\Type("string")
     * @var string
     */
    private $status;

    /**
     * @Serializer\SerializedName("Count")
     * @Serializer\Type("integer")
     * @var string
     */
    private $count;

    /**
     * @Serializer\SerializedName("Offset")
     * @Serializer\Type("integer")
     * @var integer
     */
    private $offset;

    /**
     * @Serializer\SerializedName("Limit")
     * @Serializer\Type("integer")
     * @var integer
     */
    private $limit;

    /**
     * @Serializer\SerializedName("UserGroupTypes")
     * @Serializer\Type("array<Sso\WebserviceBundle\Services\UserGroup\Search\Response\Version2\UserGroupType>")
     * @Serializer\XmlList(entry="UserGroupType")
     * @var UserGroupType[]
     */
    private $userGroupTypes = [];

    /**
     * @param string $status
     * @return Search
     */
    public function setStatus($status)
    {
        $this->status = $status;
        return $this;
    }

    /**
     * @param string $count
     */
    public function setCount(string $count): void
    {
        $this->count = $count;
    }

    /**
     * @param int $offset
     */
    public function setOffset(int $offset): void
    {
        $this->offset = $offset;
    }

    /**
     * @param int $limit
     */
    public function setLimit(int $limit): void
    {
        $this->limit = $limit;
    }

    /**
     * @param UserGroupType $userGroupType
     * @return Search
     */
    public function addUserGroupType(UserGroupType $userGroupType)
    {
        $this->userGroupTypes[] = $userGroupType;
        return $this;
    }
}
