<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\UserGroup\Update\Request\Version2;

use Symfony\Component\Validator\Constraints as Assert;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class UserGroupType
 *
 * @Serializer\XmlRoot("UserGroupType")
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\WebserviceBundle\Services\UserGroup\Update\Request\Version2
 */
class UserGroupType
{
    /**
     * @Assert\Length(max="64")
     *
     * @Serializer\SerializedName("Name")
     * @Serializer\Type("string")
     * @var string|null
     */
    private $name;

    /**
     * @Assert\Length(max="255")
     *
     * @Serializer\SerializedName("Description")
     * @Serializer\Type("string")
     * @var string|null
     */
    private $description;

    /**
     * @return string|null
     */
    public function getName(): ?string
    {
        return $this->name;
    }

    /**
     * @return string|null
     */
    public function getDescription(): ?string
    {
        return $this->description;
    }
}
