<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\UserGroup\Update\Response\Version2;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class UserGroupType
 * @package Sso\WebserviceBundle\Services\UserGroup\Update\Response\Version2
 */
final class UserGroupType
{
    /**
     * @Serializer\SerializedName("Id")
     * @Serializer\Type("integer")
     * @var int
     */
    private $id;

    /**
     * @Serializer\SerializedName("Name")
     * @Serializer\Type("string")
     * @var string
     */
    private $name;

    /**
     * @Serializer\SerializedName("Description")
     * @Serializer\Type("string")
     * @var string|null
     */
    private $description;

    /**
     * @Serializer\SerializedName("CreatedAt")
     * @Serializer\Type("DateTime")
     * @var \DateTime
     */
    private $createdAt;

    /**
     * @Serializer\SerializedName("UpdatedAt")
     * @Serializer\Type("DateTime")
     * @var \DateTime
     */
    private $updatedAt;

    /**
     * @param array $userGroupAttributes
     */
    public function setFromArray(array $userGroupAttributes)
    {
        foreach ($userGroupAttributes as $name => $value) {
            $method = 'set' . ucfirst($name);
            if (!method_exists($this, $method)) {
                throw new \BadMethodCallException(sprintf(
                    'Unable to create userGroup response model %s! UserGroup attribute %s does not exist.',
                    self::class,
                    $name
                ));
            }
            $this->$method($value);
        }
    }

    /**
     * @param int $id
     */
    public function setId(int $id): void
    {
        $this->id = $id;
    }

    /**
     * @param string $name
     */
    public function setName(string $name): void
    {
        $this->name = $name;
    }

    /**
     * @param string|null $description
     */
    public function setDescription(?string $description): void
    {
        $this->description = $description;
    }

    /**
     * @param \DateTime $createdAt
     */
    public function setCreatedAt(\DateTime $createdAt): void
    {
        $this->createdAt = $createdAt;
    }

    /**
     * @param \DateTime $updatedAt
     */
    public function setUpdatedAt(\DateTime $updatedAt): void
    {
        $this->updatedAt = $updatedAt;
    }
}
