<?php

/**
 * Class Key
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\UserSearch\Advanced\Request\Version2;

use Doctrine\Common\Collections\ArrayCollection;
use Symfony\Component\Validator\Constraints as Assert;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class Key
 *
 * @Serializer\XmlRoot("Key")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\WebserviceBundle\Services\UUserSearch\Advanced\Request\Version2;
 */
final class Filters
{

    /**
     * @Assert\Valid
     *
     * @Serializer\SerializedName("Filter")
     * @Serializer\Type("ArrayCollection<Sso\WebserviceBundle\Services\UserSearch\Advanced\Request\Version2\Filter>")
     * @Serializer\XmlList(inline = true, entry = "Filter")
     * @var Filter[]
     */
    private $filter;

    public function __construct()
    {
        $this->filter = new ArrayCollection();
    }

    /**
     * @return Filter[]
     */
    public function getFilter()
    {
        return $this->filter;
    }

    /**
     * @param Filter[] $filter
     * @return Filters
     */
    public function addFilter($filter)
    {
        $this->filter->add($filter);

        return $this;
    }

}
