<?php

/**
 * Class Show
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\UserSearch\Advanced\Response\Version2;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class Show
 * @package Sso\WebserviceBundle\Services\UserApplication\ShowDetails\Response\Version2
 */
final class Users
{
    /**
     * @Serializer\SerializedName("User")
     * @Serializer\Type("ArrayCollection<Sso\WebserviceBundle\Services\UserSearch\Advanced\Response\Version2\User>")
     * @Serializer\XmlList(inline = true, entry = "User")
     * @var User[]
     */
    private $users;


    public function __construct()
    {
        $this->users = new ArrayCollection();
    }

    /**
     * @param User $user
     * @return Users
     */
    public function addUser(User $user)
    {
        $this->users->add($user);

        return $this;
    }

    /**
     * @return User[]
     */
    public function getUsers()
    {
        return $this->users;
    }
}
