<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\UserSearch\FindByApplication\RequestData;

/**
 * Class User
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\WebserviceBundle\Services\UserSearch\FindByApplication\RequestData
 */
final class UserSearch
{
    /**
     * @var \DateTime
     */
    private $modifiedAfter = null;

    /**
     * @var string
     */
    private $applicationName = null;

    /**
     * @var boolean
     */
    private $applicationActive = null;

    /**
     * @return \DateTime
     */
    public function getModifiedAfter()
    {
        return $this->modifiedAfter;
    }

    /**
     * @param \DateTime $modifiedAfter
     * @return UserSearch
     */
    public function setModifiedAfter($modifiedAfter)
    {
        $this->modifiedAfter = $modifiedAfter;

        return $this;
    }

    /**
     * @return string
     */
    public function getApplicationName()
    {
        return $this->applicationName;
    }

    /**
     * @param string $applicationName
     * @return UserSearch
     */
    public function setApplicationName($applicationName)
    {
        $this->applicationName = $applicationName;

        return $this;
    }

    /**
     * @return int
     */
    public function getApplicationActive()
    {
        return $this->applicationActive;
    }

    /**
     * @param null|int $applicationActive
     * @return UserSearch
     */
    public function setApplicationActive($applicationActive)
    {
        if(null !== $applicationActive){
            $this->applicationActive = ($applicationActive == 1);
        } else {
            $this->applicationActive = $applicationActive;
        }

        return $this;
    }
}
