<?php

/**
 * Class User
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\UserSearch\FindByApplicationAttribute\Request\Version2;

use Symfony\Component\Validator\Constraints as Assert;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class UserSearch
 *
 * @Serializer\XmlRoot("UserSearch")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\WebserviceBundle\Services\UserSearch\FindByApplicationAttribute\Request\Version2
 */
final class UserSearch
{

    /**
     * @Assert\NotBlank()
     * @Assert\Valid
     *
     * @Serializer\SerializedName("FindByApplicationAttribute")
     * @Serializer\Type("Sso\WebserviceBundle\Services\UserSearch\FindByApplicationAttribute\Request\Version2\FindByApplicationAttribute")
     * @var FindByApplicationAttribute
     */
    private $findByApplicationAttribute;

    /**
     * @return FindByApplicationAttribute
     */
    public function getFindByApplicationAttribute()
    {
        return $this->findByApplicationAttribute;
    }
}
