<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\UserSearch\FindByApplicationAttribute\RequestData;

/**
 * Class User
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\WebserviceBundle\Services\UserSearch\FindByApplicationAttribute\RequestData
 */
final class UserSearch
{
    /**
     * @var \DateTime
     */
    private $modifiedAfter = null;

    /**
     * @var string
     */
    private $applicationName = null;

    /**
     * @var bool
     */
    private $applicationActive = null;

    /**
     * @var string
     */
    private $attributeName = null;

    /**
     * @var string
     */
    private $attibuteValue = null;

    /**
     * @return \DateTime
     */
    public function getModifiedAfter()
    {
        return $this->modifiedAfter;
    }

    /**
     * @param \DateTime $modifiedAfter
     * @return UserSearch
     */
    public function setModifiedAfter( \DateTime $modifiedAfter)
    {
        $this->modifiedAfter = $modifiedAfter;
        return $this;
    }

    /**
     * @return string
     */
    public function getApplicationName()
    {
        return $this->applicationName;
    }

    /**
     * @param string $applicationName
     * @return UserSearch
     */
    public function setApplicationName($applicationName)
    {
        $this->applicationName = $applicationName;
        return $this;
    }

    /**
     * @return bool
     */
    public function isApplicationActive()
    {
        return $this->applicationActive;
    }

    /**
     * @param int $applicationActive
     * @return UserSearch
     */
    public function setApplicationActive($applicationActive)
    {
        if(null !== $applicationActive){
            $this->applicationActive = ($applicationActive == 1);
        } else {
            $this->applicationActive = $applicationActive;
        }
        return $this;
    }

    /**
     * @return string
     */
    public function getAttributeName()
    {
        return $this->attributeName;
    }

    /**
     * @param string $attributeName
     * @return UserSearch
     */
    public function setAttributeName($attributeName)
    {
        $this->attributeName = $attributeName;
        return $this;
    }

    /**
     * @return string
     */
    public function getAttibuteValue()
    {
        return $this->attibuteValue;
    }

    /**
     * @param string $attibuteValue
     * @return UserSearch
     */
    public function setAttibuteValue($attibuteValue)
    {
        $this->attibuteValue = $attibuteValue;
        return $this;
    }
}
