<?php

/**
 * Class Show
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\UserSearch\FindByApplicationAttribute\Response\Version2;

use Sso\WebserviceBundle\ErrorHandler\Response\ErrorsInterface;
use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class Show
 * @package Sso\WebserviceBundle\Services\UserSearch\FindByApplicationAttribute\Response\Version2
 */
final class FindByApplicationAttribute
{
    /**
     * @Serializer\SerializedName("Status")
     * @Serializer\Type("string")
     * @var string
     */
    private $status;

    /**
     * @Serializer\XmlList(inline = true)
     * @var ErrorsInterface
     */
    private $errors;

    /**
     * @Serializer\SerializedName("UserType")
     * @Serializer\Type("ArrayCollection<Sso\WebserviceBundle\Services\UserSearch\FindByApplicationAttribute\Response\Version2\UserType>")
     * @Serializer\XmlList(inline=true, entry="UserType")
     * @var UserType
     */
    private $userType;

    /**
     * FindByApplication constructor.
     */
    public function __construct()
    {
        $this->userType = new ArrayCollection();
    }

    /**
     * @param string $status
     * @return FindByApplicationAttribute
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * @param ErrorsInterface $errors
     * @return FindByApplicationAttribute
     */
    public function setErrors($errors)
    {
        $this->errors = $errors;

        return $this;
    }

    /**
     * @param UserType $userType
     * @return FindByApplicationAttribute
     */
    public function addUserType(UserType $userType)
    {
        $this->userType->add($userType);

        return $this;
    }
}
