<?php

/**
 * Class UserType
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\UserSearch\FindByApplicationRole\Request\Version2;

use Symfony\Component\Validator\Constraints as Assert;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class UserType
 *
 * @Serializer\XmlRoot("RoleType")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\WebserviceBundle\Services\UserSearch\FindByApplicationRole\Request\Version2
 */
final class RoleType
{
    /**
     * @Assert\NotBlank()
     *
     * @Serializer\SerializedName("Name")
     * @Serializer\Type("string")
     * @var string
     */
    private $name;

    /**
     * @Assert\Regex(
     *     pattern="/(0|1)/",
     *     match=true,
     *     message="The Active Flag can only contain 0 or 1"
     * )
     *
     * @Serializer\SerializedName("Active")
     * @Serializer\Type("integer")
     * @var integer
     */
    private $active;

    /**
     * @return boolean
     */
    public function isActive()
    {
        return $this->active;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
}
