<?php

/**
 * Class SsoWebserviceBundle
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH   * (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       www.life-style.de
 */

namespace Sso\WebserviceBundle;

use Sso\WebserviceBundle\DependencyInjection\Compiler\ApplicationAttributeGeneratorPass;
use Sso\WebserviceBundle\DependencyInjection\Compiler\PasswordCryptPass;
use Symfony\Component\HttpKernel\Bundle\Bundle;
use Sso\WebserviceBundle\Security\Api\Factory\WebserviceFactory;
use Symfony\Component\DependencyInjection\ContainerBuilder;

/**
 * Class SsoWebserviceBundle
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       www.life-style.de
 * @package    Sso\WebserviceBundle
 */
class SsoWebserviceBundle extends Bundle
{

    /**
     *
     * @param ContainerBuilder $container
     */
    public function build(ContainerBuilder $container)
    {
        parent::build($container);

        $container->addCompilerPass(new ApplicationAttributeGeneratorPass());
        $container->addCompilerPass(new PasswordCryptPass());
        $container->getExtension('security')->addSecurityListenerFactory(new WebserviceFactory());
    }

}
