<?php

/**
 * User: sb
 * Date: 19.05.2014
 * Time: 17:10
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH   * (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id$
 * @link       www.life-style.de
 */

namespace Sso\WebserviceBundle\Tests\Api;

use Sso\WebserviceBundle\Tests\FunctionalTestCase;
use Symfony\Component\DependencyInjection\ContainerInterface as Container;
use Sso\WebserviceBundle\Api\Logger\Index as LoggerIndex;
use Sso\WebserviceBundle\Api\Mail\IndexMail;
use Sso\WebserviceBundle\Api\Configuration\IndexConfiguration;
use Sso\WebserviceBundle\Api\Controller\IndexController;
use Sso\WebserviceBundle\Api\Credentials\Index as CredentialsIndex;
use Sso\WebserviceBundle\Database\Manager as DatabaseManager;
use Sso\Tools\UserIdentifierBundle\Api\ControllerInterface as ApiController;
use Sso\WebserviceBundle\Api\Mapper\Index as MapperIndex;
use Symfony\Component\Validator\Validator\ValidatorInterface;
use JMS\Serializer\SerializerInterface;
use Symfony\Component\HttpKernel\Profiler\Profiler;
use Sso\WebserviceBundle\ErrorHandler\ErrorHandler;

/**
 * Class CredentialsTest
 * @package Sso\WebserviceBundle\Tests\Api
 */
class ManagerTest extends FunctionalTestCase
{

    public function testApiManagerReturnsOne()
    {
        $this->assertInstanceOf(Container::class, $this->apiM->container);
        $this->assertInstanceOf(LoggerIndex::class, $this->apiM->logger());
        $this->assertInstanceOf(Profiler::class, $this->apiM->profiler());
        $this->assertInstanceOf(IndexMail::class, $this->apiM->mail());
        $this->assertInstanceOf(IndexConfiguration::class, $this->apiM->configuration());
        $this->assertInstanceOf(ValidatorInterface::class, $this->apiM->validator());
        $this->assertInstanceOf(IndexController::class, $this->apiM->controller());
    }

    public function testApiManagerReturnsTwo()
    {
        $this->assertInstanceOf(CredentialsIndex::class, $this->apiM->credentials());
        $this->assertInstanceOf(DatabaseManager::class, $this->apiM->database());
        $this->assertInstanceOf(ApiController::class, $this->apiM->userService());
        $this->assertInstanceOf(SerializerInterface::class, $this->apiM->serializer());
        $this->assertInstanceOf(ErrorHandler::class, $this->apiM->errorHandler());
        $this->assertInstanceOf(MapperIndex::class, $this->apiM->mapper());
    }
}
