<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Tests\Api\PasswordPolicy\User\Model;

use Sso\WebserviceBundle\Api\PasswordPolicy\User\Model\UserPasswordResetCheckResponse;
use Sso\WebserviceBundle\Api\PasswordPolicy\User\Model\UsersPasswordPolicy;
use PHPUnit\Framework\TestCase;

/**
 * Class PwdResetCheckResponseTest
 * @package Sso\WebserviceBundle\Tests\Api\PasswordPolicy\User\Model
 */
class PwdResetCheckResponseTest extends TestCase
{

    public function testResponseModel()
    {
        $model = new UserPasswordResetCheckResponse();

        $model->setResetPasswordTokenExpire(new \DateTime('2018-01-01 00:00:05'));
        $this->assertEquals(new \DateTime('2018-01-01 00:00:05'), $model->getResetPasswordTokenExpire());

        $model->setResetPasswordToken('123456');
        $this->assertEquals('123456', $model->getResetPasswordToken());

        $model->setForcePasswordReset(true);
        $this->assertEquals(true, $model->isForcePasswordReset());

        $model->setPasswordValidUntil(new \DateTime('2018-01-01 00:00:05'));
        $this->assertEquals(new \DateTime('2018-01-01 00:00:05'), $model->getPasswordValidUntil());

        $policy = new UsersPasswordPolicy();
        $policy->setValidityDuration(2);
        $policy->setChangeDelay(3);
        $policy->setRegEx('/test/');
        $policy->setPolicyId('4711');

        $model->setPasswordPolicy($policy);

        $this->assertEquals(2, $model->getPasswordPolicy()->getValidityDuration());
        $this->assertEquals(3, $model->getPasswordPolicy()->getChangeDelay());
        $this->assertEquals('/test/', $model->getPasswordPolicy()->getRegEx());
        $this->assertEquals('4711', $model->getPasswordPolicy()->getPolicyId());
    }
}
