<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Tests\Entity\Webservice\Type;

use Sso\WebserviceBundle\Entity\Webservice\Type\PasswordPolicy;

/**
 * Class PasswordPolicyTest
 * @package Sso\WebserviceBundle\Tests\Entity\Webservice\Type
 */
class PasswordPolicyTest extends \PHPUnit\Framework\TestCase
{
    public function testEntity(){
        $entity = new PasswordPolicy();
        $entity->setPolicyId('123456789');
        $entity->setTitle('title');
        $entity->setRegEx('/(a-z)/');
        $entity->setValidityDuration(1);
        $entity->setHistorySize(2);
        $entity->setEditDistance(3);
        $entity->setChangeDelay(4);
        $entity->setPolicyDescription('policyDescription');
        $entity->setDefault(true);

        $this->assertEquals('123456789', $entity->getPolicyId());
        $this->assertEquals('title', $entity->getTitle());
        $this->assertEquals('/(a-z)/', $entity->getRegEx());
        $this->assertEquals(1, $entity->getValidityDuration());
        $this->assertEquals(2, $entity->getHistorySize());
        $this->assertEquals(3, $entity->getEditDistance());
        $this->assertEquals(4, $entity->getChangeDelay());
        $this->assertEquals('policyDescription', $entity->getPolicyDescription());
        $this->assertEquals(true, $entity->isDefault());
    }
}
