<?php

/**
 * User: sb
 * Date: 20.05.2014
 * Time: 17:10
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH   * (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id$
 * @link       www.life-style.de
 */

namespace Sso\WebserviceBundle\Tests\Functional;

use Sso\WebserviceBundle\Tests\FunctionalTestCase;

class ApplicationTest extends FunctionalTestCase
{

    /**
     * @var string
     */
    protected $applicationName = 'MyNewAppName';

    /**
     * @var string
     */
    protected $attributeName = "MyNewAttributeName";

    /**
     * @var string
     */
    protected $roleName = "MyNewRoleName";


    public function testApplicationWsVersionOne()
    {

        $this->applicationAddSuccess();
        $this->applicationShowSuccess();
        $this->applicationAttributeAddSuccess();
        $this->applicationAttributeShowSuccess();
        $this->applicationAttributeDeleteSuccess();
        $this->roleAddSuccess();
        $this->roleShowSuccess();
        $this->roleDeleteSuccess();
        $this->applicationDeleteSuccess();

    }

    /**
     * Add application
     */
    public function applicationAddSuccess()
    {
        $xml = '<?xml version="1.0"?>
                    <SsoRequest>'.$this->xmlCredentials.'
                      <Application>
                        <Add>
                            <Value>
                              <ApplicationType>
                                <Name>'.$this->applicationName.'</Name>
                                <Description>For Testing</Description>
                              </ApplicationType>
                            </Value>
                        </Add>
                      </Application>
                    </SsoRequest>';
        $response = $this->sendRequest($xml, 'Application', 'Add');
        $this->assertContains('<Status>Success</Status>', $response->getContent());
    }

    /**
     * Show application
     */
    public function applicationShowSuccess()
    {
        $xml = '<?xml version="1.0"?>
                    <SsoRequest>'.$this->xmlCredentials.'
                      <Application>
                        <Show>
                            <Key>
                              <ApplicationType>
                                <Name>'.$this->applicationName.'</Name>
                              </ApplicationType>
                            </Key>
                        </Show>
                      </Application>
                    </SsoRequest>';
        echo $this->ApplicationName;
        $response = $this->sendRequest($xml, 'Application', 'Show');
        $this->assertContains('<Status>Success</Status>', $response->getContent());
    }

    /**
     * Add attribute to application
     *
     */
    public function applicationAttributeAddSuccess()
    {
        $xml = '<?xml version="1.0"?>
                    <SsoRequest>'.$this->xmlCredentials.'
                      <ApplicationAttribute>
                        <Add>
                            <Key>
                              <ApplicationType>
                                <Name>'.$this->applicationName.'</Name>
                              </ApplicationType>
                            </Key>
                            <Value>
                              <AttributeType>
                                <Name>'.$this->attributeName.'</Name>
                                <Type>one</Type>
                              </AttributeType>
                            </Value>
                        </Add>
                      </ApplicationAttribute>
                    </SsoRequest>';
        $response = $this->sendRequest($xml, 'ApplicationAttribute', 'Add');
        $this->assertContains('<Status>Success</Status>', $response->getContent());
    }

    /**
     * Show attribute from application
     *
     */
    public function applicationAttributeShowSuccess()
    {
        $xml = '<?xml version="1.0"?>
                    <SsoRequest>'.$this->xmlCredentials.'
                      <ApplicationAttribute>
                        <Show>
                            <Key>
                              <ApplicationType>
                                <Name>'.$this->applicationName.'</Name>
                              </ApplicationType>
                              <AttributeType>
                                <Name>'.$this->attributeName.'</Name>
                              </AttributeType>
                            </Key>
                        </Show>
                      </ApplicationAttribute>
                    </SsoRequest>';
        $response = $this->sendRequest($xml, 'ApplicationAttribute', 'Show');
        $this->assertContains('<Status>Success</Status>', $response->getContent());
    }

    /**
     * Delete attribute from application
     *
     */
    public function applicationAttributeDeleteSuccess()
    {
        $xml = '<?xml version="1.0"?>
                    <SsoRequest>'.$this->xmlCredentials.'
                      <ApplicationAttribute>
                        <Delete>
                            <Key>
                              <ApplicationType>
                                <Name>'.$this->applicationName.'</Name>
                              </ApplicationType>
                              <AttributeType>
                                <Name>'.$this->attributeName.'</Name>
                              </AttributeType>
                            </Key>
                        </Delete>
                      </ApplicationAttribute>
                    </SsoRequest>';
        $response = $this->sendRequest($xml, 'ApplicationAttribute', 'Delete');
        $this->assertContains('<Status>Success</Status>', $response->getContent());
    }

    /**
     * Add role to application
     *
     */
    public function roleAddSuccess()
    {
        $xml = '<?xml version="1.0"?>
                    <SsoRequest>'.$this->xmlCredentials.'
                      <ApplicationRole>
                        <Add>
                            <Key>
                              <ApplicationType>
                                <Name>'.$this->applicationName.'</Name>
                              </ApplicationType>
                            </Key>
                            <Value>
                              <RoleType>
                                <Name>'.$this->roleName.'</Name>
                              </RoleType>
                            </Value>
                        </Add>
                      </ApplicationRole>
                    </SsoRequest>';
        $response = $this->sendRequest($xml, 'ApplicationRole', 'Add');
        $this->assertContains('<Status>Success</Status>', $response->getContent());
    }

    /**
     * Show role from application
     *
     */
    public function roleShowSuccess()
    {
        $xml = '<?xml version="1.0"?>
                    <SsoRequest>'.$this->xmlCredentials.'
                      <ApplicationRole>
                        <Show>
                            <Key>
                              <ApplicationType>
                                <Name>'.$this->applicationName.'</Name>
                              </ApplicationType>
                              <RoleType>
                                <Name>'.$this->roleName.'</Name>
                              </RoleType>
                            </Key>
                        </Show>
                      </ApplicationRole>
                    </SsoRequest>';
        $response = $this->sendRequest($xml, 'ApplicationRole', 'Show');
        $this->assertContains('<Status>Success</Status>', $response->getContent());
    }

    /**
     * Delete role from application
     *
     */
    public function roleDeleteSuccess()
    {
        $xml = '<?xml version="1.0"?>
                    <SsoRequest>'.$this->xmlCredentials.'
                      <ApplicationRole>
                        <Delete>
                            <Key>
                              <ApplicationType>
                                <Name>'.$this->applicationName.'</Name>
                              </ApplicationType>
                              <RoleType>
                                <Name>'.$this->roleName.'</Name>
                              </RoleType>
                            </Key>
                        </Delete>
                      </ApplicationRole>
                    </SsoRequest>';
        $response = $this->sendRequest($xml, 'ApplicationRole', 'Delete');
        $this->assertContains('<Status>Success</Status>', $response->getContent());
    }

    /**
     * Delete application
     *
     */
    public function applicationDeleteSuccess()
    {
        $xml = '<?xml version="1.0"?>
                    <SsoRequest>'.$this->xmlCredentials.'
                      <Application>
                        <Delete>
                            <Key>
                              <ApplicationType>
                                <Name>'.$this->applicationName.'</Name>
                              </ApplicationType>
                            </Key>
                        </Delete>
                      </Application>
                    </SsoRequest>';
        $response = $this->sendRequest($xml, 'Application', 'Delete');
        $this->assertContains('<Status>Success</Status>', $response->getContent());
    }
}
