<?php

/**
 * User: sb
 * Date: 20.05.2014
 * Time: 17:10
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH   * (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id$
 * @link       www.life-style.de
 */

namespace Sso\WebserviceBundle\Tests\Functional;

use Sso\WebserviceBundle\Tests\FunctionalTestCase;

class FunctionalUserTest extends FunctionalTestCase
{

    /**
     * @var string
     */
    protected $applicationName = 'MyNewAppName';


    public function testUser(){
        $this->userAddSuccess();
        $this->applicationAddSuccess();
        $this->userApplicationAddSuccess();
        $this->userApplicationDeleteSuccess();
        $this->applicationDeleteSuccess();
        $this->userDeleteSuccess();

    }

    /**
     * Add user
     */
    public function userAddSuccess()
    {
        $xml = '<?xml version="1.0"?>
                    <SsoRequest>' . $this->xmlCredentials . '
                      <User>
                        <Add>
                            <Value>
                              <UserType>
                                <Email>' . $this->Email . '</Email>
                                <Username>' . $this->Username . '</Username>
                                <Firstname>Testers firstname</Firstname>
                                <Lastname>Testers lastname</Lastname>
                                <Password>SumpfTest#1234</Password>
                                <Active>0</Active>
                              </UserType>
                            </Value>
                        </Add>
                      </User>
                    </SsoRequest>';
        $response = $this->sendRequest($xml, 'User', 'Add');
        $this->assertContains('<Status>Success</Status>', $response->getContent());
    }
    
    /**
     * Add application
     */
    public function applicationAddSuccess()
    {
        $xml = '<?xml version="1.0"?>
                    <SsoRequest>' . $this->xmlCredentials . '
                      <Application>
                        <Add>
                            <Value>
                              <ApplicationType>
                                <Name>' . $this->applicationName . '</Name>
                                <Description>For Testing</Description>
                              </ApplicationType>
                            </Value>
                        </Add>
                      </Application>
                    </SsoRequest>';
        $response = $this->sendRequest($xml, 'Application', 'Add');
        $this->assertContains('<Status>Success</Status>', $response->getContent());
    }

    /**
     * Add application to user
     * 
     * @depends testUserAddSuccess
     * @depends testApplicationAddSuccess
     */
    public function userApplicationAddSuccess()
    {
        $xml = '<?xml version="1.0"?>
                    <SsoRequest>' . $this->xmlCredentials . '
                      <UserApplication>
                        <Add>
                            <Key>
                              <UserType>
                                <Email>' . $this->Email . '</Email>
                              </UserType>
                            </Key>
                            <Value>
                              <ApplicationType>
                                <Name>' . $this->applicationName . '</Name>
                                <Active>' . rand(0, 1) . '</Active>
                              </ApplicationType>
                            </Value>
                        </Add>
                      </UserApplication>
                    </SsoRequest>';
        $response = $this->sendRequest($xml, 'UserApplication', 'Add');
        $this->assertContains('<Status>Success</Status>', $response->getContent());
    }

    /**
     * Delete application from user
     * 
     * @depends testUserApplicationAddSuccess
     */
    public function userApplicationDeleteSuccess()
    {
        $xml = '<?xml version="1.0"?>
                    <SsoRequest>' . $this->xmlCredentials . '
                      <UserApplication>
                        <Delete>
                            <Key>
                              <UserType>
                                <Email>' . $this->Email . '</Email>
                              </UserType>
                              <ApplicationType>
                                <Name>' . $this->applicationName . '</Name>
                              </ApplicationType>
                            </Key>
                        </Delete>
                      </UserApplication>
                    </SsoRequest>';
        $response = $this->sendRequest($xml, 'UserApplication', 'Delete');
        $this->assertContains('<Status>Success</Status>', $response->getContent());
    }

    /**
     * Delete application
     * 
     * @depends testApplicationAddSuccess
     */
    public function applicationDeleteSuccess()
    {
        $xml = '<?xml version="1.0"?>
                    <SsoRequest>' . $this->xmlCredentials . '
                      <Application>
                        <Delete>
                            <Key>
                              <ApplicationType>
                                <Name>' . $this->applicationName . '</Name>
                              </ApplicationType>
                            </Key>
                        </Delete>
                      </Application>
                    </SsoRequest>';
        $response = $this->sendRequest($xml, 'Application', 'Delete');
        $this->assertContains('<Status>Success</Status>', $response->getContent());
    }

    /**
     * Delete user
     * 
     * @depends testUserAddSuccess
     */
    public function userDeleteSuccess()
    {
        $xml = '<?xml version="1.0"?>
                    <SsoRequest>' . $this->xmlCredentials . '
                      <User>
                        <Delete>
                            <Key>
                              <UserType>
                                <Email>' . $this->Email . '</Email>
                              </UserType>
                            </Key>
                        </Delete>
                      </User>
                    </SsoRequest>';
        $response = $this->sendRequest($xml, 'User', 'Delete');
        $this->assertContains('<Status>Success</Status>', $response->getContent());
    }
}
