<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Tests\Functional\Services\Helper;

/**
 * Class Configuration
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */
class Configuration
{
    /**
     * @var string
     */
    private $cachePath;

    /**
     * @var string
     */
    private $urlUserWs;

    /**
     * @var string
     */
    private $serviceToken;

    /**
     * @var string
     */
    private $username;

    /**
     * @var string
     */
    private $userIdentifier;

    /**
     * Configuration constructor.
     * @param string $cachePath
     * @param string $urlUserWs
     * @param string $serviceToken
     * @param string $username
     */
    public function __construct($cachePath, $urlUserWs, $serviceToken, $username)
    {
        $this->cachePath = $cachePath;
        $this->urlUserWs = $urlUserWs;
        $this->serviceToken = $serviceToken;
        $this->username = $username;
    }

    /**
     * @return string
     */
    public function getCachePath()
    {
        return $this->cachePath;
    }

    /**
     * @return string
     */
    public function getUrlUserWs()
    {
        return $this->urlUserWs;
    }

    /**
     * @param string $urlUserWs
     */
    public function setUrlUserWs($urlUserWs)
    {
        $this->urlUserWs = $urlUserWs;
    }

    /**
     * @return string
     */
    public function getServiceToken()
    {
        return $this->serviceToken;
    }

    /**
     * @param string $serviceToken
     */
    public function setServiceToken($serviceToken)
    {
        $this->serviceToken = $serviceToken;
    }

    /**
     * @return string
     */
    public function getUsername()
    {
        return $this->username;
    }

    /**
     * @param string $username
     */
    public function setUsername($username)
    {
        $this->username = $username;
    }

    /**
     * @return string
     */
    public function getUserIdentifier()
    {
        return $this->userIdentifier;
    }

    /**
     * @param string $userIdentifier
     */
    public function setUserIdentifier($userIdentifier)
    {
        $this->userIdentifier = $userIdentifier;
    }
}
