<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version1\ApplicationRole;

use Symfony\Bundle\FrameworkBundle\Client;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Credentials;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Configuration;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version1\Constants;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version1\Model\Application;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version1\Model\ApplicationRole;
use Faker\Factory;

/**
 * Class Add
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Version1\ApplicationRole
 */
class Add
{
    /**
     * @var Configuration
     */
    private $configuration;

    /**
     * @var Client
     */
    private $client;

    /**
     * Delete constructor.
     * @param Configuration $configuration
     * @param Client $client
     */
    public function __construct(Configuration $configuration, Client $client)
    {
        $this->configuration = $configuration;
        $this->client = $client;
    }

    /**
     * @param Application $application
     * @return ApplicationRole
     */
    public function execute(Application $application)
    {
        $faker = Factory::create();
        $applicationRole = new ApplicationRole();
        $applicationRole->setName(Constants::PREFIX . $faker->lastName);

        $this->client->request(
            'POST',
            $this->configuration->getUrlUserWs(),
            [],
            [],
            [
                'HTTP_API-CONTROLLER' => 'ApplicationRole',
                'HTTP_API-ACTION' => 'Add',
                'CONTENT-TYPE' => 'text/xml; charset=UTF-8',
                'HTTP_API-VERSION' => '1',
                'HTTP_REMOTE_ADDR' => '127.0.0.1',
            ],
            $this->getRequest($application, $applicationRole)
        );

        return $applicationRole;
    }

    /**
     * @param Application $application
     * @param ApplicationRole $applicationRole
     * @return string
     */
    private function getRequest(Application $application, ApplicationRole $applicationRole)
    {
        return '<?xml version="1.0" encoding="UTF-8"?>
<SsoRequest>' . (string)(new Credentials($this->configuration)) . '
    <ApplicationRole>
        <Add>
            <Key>
                <ApplicationType>
                    <Name>' . $this->cdata($application->getName()) . '</Name>
                </ApplicationType>
            </Key>
            <Value>
                <RoleType>
                    <Name>' . $this->cdata($applicationRole->getName()) . '</Name>
                    <Description>' . $this->cdata($applicationRole->getDescription()) . '</Description>
                </RoleType>
            </Value>
        </Add>
    </ApplicationRole>
</SsoRequest>';
    }

    /**
     * @param string $value
     * @return string
     */
    protected function cdata($value)
    {
        return '<![CDATA[' . $value . ']]>';
    }
}
