<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version1\Model;

/**
 * Class User
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Version1\Model
 */
class User
{
    /**
     * @var string|null
     */
    private $guid;

    /**
     * @var string
     */
    private $username = '';

    /**
     * @var string
     */
    private $email = '';

    /**
     * @var string
     */
    private $firstname = '';

    /**
     * @var string
     */
    private $lastname = '';

    /**
     * @var string
     */
    private $password = '';

    /**
     * @var bool
     */
    private $active = '';

    /**
     * @var string
     */
    private $authId = '';

    /**
     * @var string
     */
    private $ldapSearchAttributes = '';

    /**
     * @var string
     */
    private $ldapSearchValue = '';

    /**
     * @var string
     */
    private $activateToken;

    /**
     * @var string
     */
    private $passwordToken;

    /**
     * @return null|string
     */
    public function getGuid()
    {
        return $this->guid;
    }

    /**
     * @param null|string $guid
     */
    public function setGuid($guid)
    {
        $this->guid = $guid;
    }

    /**
     * @return string
     */
    public function getUsername()
    {
        return $this->username;
    }

    /**
     * @param string $username
     */
    public function setUsername($username)
    {
        $this->username = $username;
    }

    /**
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * @param string $email
     */
    public function setEmail($email)
    {
        $this->email = $email;
    }

    /**
     * @return string
     */
    public function getFirstname()
    {
        return $this->firstname;
    }

    /**
     * @param string $firstname
     */
    public function setFirstname($firstname)
    {
        $this->firstname = $firstname;
    }

    /**
     * @return string
     */
    public function getLastname()
    {
        return $this->lastname;
    }

    /**
     * @param string $lastname
     */
    public function setLastname($lastname)
    {
        $this->lastname = $lastname;
    }

    /**
     * @return string
     */
    public function getPassword()
    {
        return $this->password;
    }

    /**
     * @param string $password
     */
    public function setPassword($password)
    {
        $this->password = $password;
    }

    /**
     * @return boolean
     */
    public function isActive()
    {
        return $this->active;
    }

    /**
     * @param boolean $active
     */
    public function setActive($active)
    {
        $this->active = (bool)$active;
    }

    /**
     * @return string
     */
    public function getAuthId()
    {
        return $this->authId;
    }

    /**
     * @param string $authId
     */
    public function setAuthId($authId)
    {
        $this->authId = $authId;
    }

    /**
     * @return string
     */
    public function getLdapSearchAttributes()
    {
        return $this->ldapSearchAttributes;
    }

    /**
     * @param string $ldapSearchAttributes
     */
    public function setLdapSearchAttributes($ldapSearchAttributes)
    {
        $this->ldapSearchAttributes = $ldapSearchAttributes;
    }

    /**
     * @return string
     */
    public function getLdapSearchValue()
    {
        return $this->ldapSearchValue;
    }

    /**
     * @param string $ldapSearchValue
     */
    public function setLdapSearchValue($ldapSearchValue)
    {
        $this->ldapSearchValue = $ldapSearchValue;
    }

    /**
     * @return string
     */
    public function getActivateToken()
    {
        return $this->activateToken;
    }

    /**
     * @param string $activateToken
     */
    public function setActivateToken($activateToken)
    {
        $this->activateToken = $activateToken;
    }

    /**
     * @return string
     */
    public function getPasswordToken()
    {
        return $this->passwordToken;
    }

    /**
     * @param string $passwordToken
     */
    public function setPasswordToken($passwordToken)
    {
        $this->passwordToken = $passwordToken;
    }
}
