<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version2\UserApplication;

use Symfony\Bundle\FrameworkBundle\Client;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Credentials;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Configuration;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version2\Model\Application;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version2\Model\User;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version2\Model\UserApplication;

/**
 * Class Add
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Version2\UserApplication
 */
class Add
{
    /**
     * @var Configuration
     */
    private $configuration;

    /**
     * @var Client
     */
    private $client;

    /**
     * Add constructor.
     * @param Configuration $configuration
     * @param Client $client
     */
    public function __construct(Configuration $configuration, Client $client)
    {
        $this->configuration = $configuration;
        $this->client = $client;
    }

    /**
     * @param User $user
     * @param Application $application
     * @return UserApplication
     */
    public function execute(User $user, Application $application)
    {
        $userApplication = new UserApplication($user, $application);
        $this->client->request(
            'POST',
            $this->configuration->getUrlUserWs(),
            [],
            [],
            [
                'HTTP_API-CONTROLLER' => 'UserApplication',
                'HTTP_API-ACTION' => 'Add',
                'CONTENT-TYPE' => 'text/xml; charset=UTF-8',
                'HTTP_API-VERSION' => '2',
                'HTTP_REMOTE_ADDR' => '127.0.0.1',
            ],
            $this->getRequest($userApplication)
        );

        return $userApplication;
    }

    /**
     * @param UserApplication $userApplication
     * @return string
     */
    private function getRequest(UserApplication $userApplication)
    {
        return '<?xml version="1.0" encoding="UTF-8"?>
<SsoRequest>' . (string)(new Credentials($this->configuration)) . '
    <UserApplication>
        <Add>
            <Key>
                <UserType>
                    <Username>' . $this->cdata($userApplication->getUser()->getUsername()) . '</Username>
                </UserType>
            </Key>
            <Value>
                <ApplicationType>
                    <Name>' . $this->cdata($userApplication->getApplication()->getName()) . '</Name>
                    <Active>' . ($userApplication->getApplication()->isActive() ? '1' : '0') . '</Active>
                </ApplicationType>
            </Value>
        </Add>
    </UserApplication>
</SsoRequest>';
    }

    /**
     * @param string $value
     * @return string
     */
    protected function cdata($value)
    {
        return '<![CDATA[' . $value . ']]>';
    }
}
