<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version2\UserApplicationRole;

use Symfony\Bundle\FrameworkBundle\Client;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Credentials;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Configuration;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version2\Constants;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version2\Model\UserApplicationRole;

/**
 * Class Delete
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Version2\UserApplicationRole
 */
class Delete
{
    /**
     * @var Configuration
     */
    private $configuration;

    /**
     * @var Client
     */
    private $client;

    /**
     * Add constructor.
     * @param Configuration $configuration
     * @param Client $client
     */
    public function __construct(Configuration $configuration, Client $client)
    {
        $this->configuration = $configuration;
        $this->client = $client;
    }

    /**
     * @param UserApplicationRole $userApplicationRole
     */
    public function execute(UserApplicationRole $userApplicationRole)
    {
        if (0 !== stripos($userApplicationRole->getApplication()->getName(), Constants::PREFIX)) {
            return;
        }
        if (0 !== stripos($userApplicationRole->getUser()->getUsername(), Constants::PREFIX)) {
            return;
        }

        $this->client->request(
            'POST',
            $this->configuration->getUrlUserWs(),
            [],
            [],
            [
                'HTTP_API-CONTROLLER' => 'UserApplicationRole',
                'HTTP_API-ACTION' => 'Delete',
                'CONTENT-TYPE' => 'text/xml; charset=UTF-8',
                'HTTP_API-VERSION' => '2',
                'HTTP_REMOTE_ADDR' => '127.0.0.1',
            ],
            $this->getRequest($userApplicationRole)
        );
    }

    /**
     * @param UserApplicationRole $userApplicationRole
     * @return string
     */
    private function getRequest(UserApplicationRole $userApplicationRole)
    {
        return '<?xml version="1.0" encoding="UTF-8"?>
<SsoRequest>' . (string)(new Credentials($this->configuration)) . '
    <UserApplicationRole>
        <Delete>
            <Key>
                <ApplicationType>
                    <Name>' . $this->cdata($userApplicationRole->getApplication()->getName()) . '</Name>
                </ApplicationType>
                <RoleType>
                    <Name>' . $this->cdata($userApplicationRole->getRole()->getName()) . '</Name>
                </RoleType>
                <UserType>
                    <Username>' . $this->cdata($userApplicationRole->getUser()->getUsername()) . '</Username>
                </UserType>
            </Key>
        </Delete>
    </UserApplicationRole>
</SsoRequest>';
    }

    /**
     * @param string $value
     * @return string
     */
    protected function cdata($value)
    {
        return '<![CDATA[' . $value . ']]>';
    }
}
