<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Tests\Functional\Services\Tests\Version1\Header;

use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Credentials;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version1\FunctionalTestCase;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Configuration;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version1\Constants;

/**
 * Class HeaderTest
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Tests\Version1\Header
 */
class HeaderTest extends FunctionalTestCase
{

    public function testInvalidActionInHeader()
    {
        $requestBody = $this->getRequest($this->configuration);
        $response = $this->sendPostRequest('User', 'InvalidAction', $requestBody);

        // Status code check
        $expectedStatusCodes = [500, 400];
        static::assertTrue(
            in_array($response->getStatusCode(), $expectedStatusCodes),
            sprintf('Status-code should be %s but is ', implode(' or ', $expectedStatusCodes), $response->getStatusCode())
        );

        $xml = $response->getContent();
        $xmlElement = $this->loadResponse($xml);

        $xmlExpectedElement = $this->loadXmlDomElement(
            __DIR__ . '/xml/response-structure-error-invalid-action-in-header.xml',
            'SsoResponse'
        );

        static::assertEqualXMLStructure(
            $xmlExpectedElement,
            $xmlElement,
            false,
            $this->fXml($requestBody, $xml, 'Xml structure check failed')
        );

        // Value check
        $xmlSimple = simplexml_load_string($xml);
        static::assertEquals(
            Constants::STATUS_FAILURE,
            (string)$xmlSimple->Status,
            $this->fXml($requestBody, $xml, 'Global xml status code does not match!')
        );

        static::assertRegExp(
            Constants::REGEXP_DATE,
            (string)$xmlSimple->Date,
            $this->fXml($requestBody, $xml, 'Date format does not match!')
        );

        static::assertEquals(
            Constants::STATUS_FAILURE,
            (string)$xmlSimple->User->Unknown->Status
        );

        static::assertRegExp(
            '/^(x004|fw002)$/',
            (string)$xmlSimple->User->Unknown->Errors->Error->ErrorCode,
            $this->fXml($requestBody, $xml, 'Error code does not match!')
        );

    }

    public function testInvalidControllerInHeader()
    {
        $requestBody = $this->getRequest($this->configuration);
        $response = $this->sendPostRequest('InvalidController', 'Show', $requestBody);

        // Status code check
        $expectedStatusCodes = [500, 400];
        static::assertTrue(
            in_array($response->getStatusCode(), $expectedStatusCodes),
            sprintf('Status-code should be %s but is ', implode(' or ', $expectedStatusCodes), $response->getStatusCode())
        );

        $xml = $response->getContent();
        $xmlElement = $this->loadResponse($xml);

        $xmlExpectedElement = $this->loadXmlDomElement(
            __DIR__ . '/xml/response-structure-error-invalid-controller-in-header.xml',
            'SsoResponse'
        );

        static::assertEqualXMLStructure(
            $xmlExpectedElement,
            $xmlElement,
            false,
            $this->fXml($requestBody, $xml, 'Xml structure check failed')
        );

        // Value check
        $xmlSimple = simplexml_load_string($xml);
        static::assertEquals(
            Constants::STATUS_FAILURE,
            (string)$xmlSimple->Status,
            $this->fXml($requestBody, $xml, 'Global xml status code does not match!')
        );

        static::assertRegExp(
            Constants::REGEXP_DATE,
            (string)$xmlSimple->Date,
            $this->fXml($requestBody, $xml, 'Date format does not match!')
        );

        static::assertEquals(
            Constants::STATUS_FAILURE,
            (string)$xmlSimple->Unknown->Unknown->Status
        );

        static::assertRegExp(
            '/^(x003|fw002)$/',
            (string)$xmlSimple->Unknown->Unknown->Errors->Error->ErrorCode,
            $this->fXml($requestBody, $xml, 'Error code does not match!')
        );
    }

    /**
     * @param Configuration $configuration
     * @return string
     */
    private function getRequest(Configuration $configuration)
    {
        return '<?xml version="1.0" encoding="UTF-8"?>
<SsoRequest>' . (string)(new Credentials($configuration)) . '<User>
        <Show>
            <Key>
                <UserType>
                    <Username>' . $this->cdata($configuration->getUsername()) . '</Username>
                </UserType>
            </Key>
        </Show>
    </User>
</SsoRequest>';
    }

}
