<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Tests\Functional\Services\Tests\Version1;

use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Credentials;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version1\FunctionalTestCase;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version1\Constants;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version1\Model\User;

/**
 * Class UserUpdateTest
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Tests\Version1
 */
class UserUpdateTest extends FunctionalTestCase
{
    public function testUpdateOfValidUser()
    {
        $user = $this->helperFactory->userAdd()->execute(false);

        $faker = \Faker\Factory::create();

        $user->setFirstname($faker->firstName);
        $user->setLastname($faker->lastName);

        $requestBody = $this->getRequest($user, true);
        $response = $this->sendPostRequest('User', 'Update', $requestBody);

        static::assertEquals(200, $response->getStatusCode());

        $xml = $response->getContent();
        $xmlElement = $this->loadResponse($xml);

        $xmlElementExpected = $this->loadXmlDomElement(
            __DIR__ . '/xml/response-structure-success.xml',
            'SsoResponse'
        );
        static::assertEqualXMLStructure(
            $xmlElementExpected,
            $xmlElement,
            false,
            $this->fXml($requestBody, $xml, 'Xml structure check failed')
        );
    }

    public function testUpdateOfInvalidUser()
    {
        $faker = \Faker\Factory::create();
        $user = new User();
        $user->setEmail(Constants::PREFIX . $faker->email);
        $user->setUsername(Constants::PREFIX . $faker->userName);
        $user->setActive(false);
        $user->setFirstname($faker->firstName);
        $user->setLastname($faker->lastName);
        $user->setPassword($faker->password(8, 120) . '_Aa1');

        $requestBody = $this->getRequest($user, true);
        $response = $this->sendPostRequest('User', 'Update', $requestBody);

        static::assertEquals(200, $response->getStatusCode());

        $xml = $response->getContent();
        $xmlElement = $this->loadResponse($xml);

        $xmlElementExpected = $this->loadXmlDomElement(
            __DIR__ . '/xml/response-structure-error.xml',
            'SsoResponse'
        );
        static::assertEqualXMLStructure(
            $xmlElementExpected,
            $xmlElement,
            false,
            $this->fXml($requestBody, $xml, 'Xml structure check failed')
        );
    }

    public function testUpdateOfActiveUserWithoutSendingActiveFlag()
    {
        $user = $this->helperFactory->userAdd()->execute(true);

        $faker = \Faker\Factory::create();

        $user->setFirstname($faker->firstName);
        $user->setLastname($faker->lastName);

        $requestBody = $this->getRequest($user, false);
        $response = $this->sendPostRequest('User', 'Update', $requestBody);

        static::assertEquals(200, $response->getStatusCode());

        $xml = $response->getContent();
        $xmlElement = $this->loadResponse($xml);

        $xmlElementExpected = $this->loadXmlDomElement(
            __DIR__ . '/xml/response-structure-success.xml',
            'SsoResponse'
        );
        static::assertEqualXMLStructure(
            $xmlElementExpected,
            $xmlElement,
            false,
            $this->fXml($requestBody, $xml, 'Xml structure check failed')
        );

        $user = $this->helperFactory->userShow()->execute($user);
        static::assertTrue($user->isActive(), 'User should be active after update, but isn\'t');
    }

    /**
     * @param User $user
     * @param bool $addActiveFlag
     * @return string
     */
    private function getRequest(User $user, $addActiveFlag)
    {
        $active = '';
        if ($addActiveFlag) {
            $active = '<Active>' . ($user->isActive() ? '1' : '0') . '</Active>';
        }

        return '<?xml version="1.0" encoding="UTF-8"?>
<SsoRequest>' . (string)(new Credentials($this->configuration)) . '<User>
        <Update>
            <Key>
                <UserType>
                    <Email>' . $this->cdata($user->getEmail()) . '</Email>
                </UserType>
            </Key>
            <Value>
                <UserType>
                    <Email>' . $this->cdata($user->getEmail()) . '</Email>
                    <Username>' . $this->cdata($user->getUsername()) . '</Username>
                    <Firstname>' . $this->cdata($user->getFirstname()) . '</Firstname>
                    <Lastname>' . $this->cdata($user->getLastname()) . '</Lastname>
                    ' . $active . '
                    <AuthId>' . $this->cdata($user->getAuthId()) . '</AuthId>
                    <LdapSearchAttributes>' . $this->cdata($user->getLdapSearchAttributes()) . '</LdapSearchAttributes>
                    <LdapSearchValue>' . $this->cdata($user->getLdapSearchValue()) . '</LdapSearchValue>
                </UserType>
            </Value>
        </Update>
    </User>
</SsoRequest>';
    }
}
