<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Tests\Functional\Services\Tests\Version2;

use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Credentials;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version2\FunctionalTestCase;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version2\Constants;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version2\Model\Application;

/**
 * Class ApplicationAllTest
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\WebserviceBundle\Tests\Functional\Services\Tests\Version2
 */
class ApplicationAllTest extends FunctionalTestCase
{
    public function testValidRequest()
    {
        $fullResponse = false;
        $requestBody = $this->getValidRequest($fullResponse);
        $response = $this->sendPostRequest('Application', 'All', $requestBody);

        static::assertEquals(200, $response->getStatusCode());

        $xml = $response->getContent();
        $xmlElement = $this->loadResponse($xml);

        $xmlElementExpected = $this->loadXmlDomElement(
            __DIR__ . '/xml/response-structure-success.xml',
            'SsoResponse'
        );

        static::assertEqualXMLStructure(
            $xmlElementExpected,
            $xmlElement,
            false,
            $this->fXml($requestBody, $xml, 'Xml structure check failed')
        );

        // Value check
        $xmlSimple = simplexml_load_string($xml);

        static::assertEquals(
            Constants::STATUS_SUCCESS,
            (string)$xmlSimple->Status,
            $this->fXml($requestBody, $xml, 'Global xml status code does not match!')
        );

        static::assertRegExp(
            Constants::REGEXP_DATE,
            (string)$xmlSimple->Date,
            $this->fXml($requestBody, $xml, 'Date format does not match!')
        );

        static::assertEquals(
            Constants::STATUS_SUCCESS,
            (string)$xmlSimple->Application->All->Status,
            $this->fXml($requestBody, $xml, 'Xml status code does not match!')
        );

        static::assertEquals(
            $fullResponse ? '1' : '0',
            (string)$xmlSimple->Application->All->FullResponse,
            $this->fXml($requestBody, $xml, 'Flag \'FullResponse\' does not match!')
        );

        // For testing there is only this application available - adjust, of more applications will be added
        static::assertEquals(
            'WebserviceConsumer',
            (string)$xmlSimple->Application->All->Application->Name,
            $this->fXml($requestBody, $xml, 'Application Name does not match!')
        );
    }

    public function testInvalidRequest()
    {
        $requestBody = $this->getInvalidRequest(false);
        $response = $this->sendPostRequest('Application', 'All', $requestBody);

        static::assertEquals(400, $response->getStatusCode());

        $xml = $response->getContent();
        $xmlElement = $this->loadResponse($xml);

        $xmlElementExpected = $this->loadXmlDomElement(
            __DIR__ . '/xml/response-structure-error.xml',
            'SsoResponse'
        );

        static::assertEqualXMLStructure(
            $xmlElementExpected,
            $xmlElement,
            false,
            $this->fXml($requestBody, $xml, 'Xml structure check failed')
        );

        // Value check
        $xmlSimple = simplexml_load_string($xml);

        static::assertEquals(
            'Bad Request',
            (string)$xmlSimple->Status,
            $this->fXml($requestBody, $xml, 'Global xml status code does not match!')
        );

        static::assertRegExp(
            Constants::REGEXP_DATE,
            (string)$xmlSimple->Date,
            $this->fXml($requestBody, $xml, 'Date format does not match!')
        );

        static::assertEquals(
            'Bad Request',
            (string)$xmlSimple->Errors->Error->Status,
            $this->fXml($requestBody, $xml, 'Xml status code does not match!')
        );
    }

    /**
     * @param bool $fullResponse
     * @return string
     */
    private function getValidRequest(bool $fullResponse)
    {
        return '<?xml version="1.0" encoding="UTF-8"?>
<SsoRequest>' . (string)(new Credentials($this->configuration)) . '
    <Application>
        <All>
            <FullResponse>' . ($fullResponse ? '1' : '0') . '</FullResponse>
        </All>
    </Application>
</SsoRequest>';
    }

    /**
     * @param bool $fullResponse
     * @return string
     */
    private function getInvalidRequest(bool $fullResponse)
    {
        return '<?xml version="1.0" encoding="UTF-8"?>
<SsoRequest>' . (string)(new Credentials($this->configuration)) . '
    <Application>
        <Invalid>
            <FullResponse>' . ($fullResponse ? '1' : '0') . '</FullResponse>
        </Invalid>
    </Application>
</SsoRequest>';
    }
}