<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Tests\Functional\Services\Tests\Version2;

use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Credentials;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version2\FunctionalTestCase;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version2\Constants;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version2\Model\Application;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version2\Model\User;

/**
 * Class UserApplicationShowTest
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Tests\Version2
 */
class UserApplicationShowTest extends FunctionalTestCase
{
    public function testSuccess()
    {
        $application = $this->helperFactory->applicationAdd()->execute();
        $this->helperFactory->userPermissionAdd()->execute($application);

        $user = $this->helperFactory->userAdd()->execute();

        $this->helperFactory->userApplicationAdd()->execute($user, $application);

        $requestBody = $this->getRequest($application, $user);
        $response = $this->sendPostRequest('UserApplication', 'Show', $requestBody);

        static::assertEquals(200, $response->getStatusCode());

        $xml = $response->getContent();
        $xmlElement = $this->loadResponse($xml);

        $xmlElementExpected = $this->loadXmlDomElement(
            __DIR__ . '/xml/response-structure-success.xml',
            'SsoResponse'
        );

        static::assertEqualXMLStructure(
            $xmlElementExpected,
            $xmlElement,
            false,
            $this->fXml($requestBody, $xml, 'Xml structure check failed')
        );
    }

    public function testInvalidUserAndValidApplication()
    {
        $faker = \Faker\Factory::create();
        $user = new User();
        $user->setEmail(Constants::PREFIX . $faker->email);
        $user->setUsername(Constants::PREFIX . $faker->userName);
        $user->setActive(true);
        $user->setFirstname($faker->firstName);
        $user->setLastname($faker->lastName);
        $user->setPassword($faker->password(8, 120) . '_Aa1');

        $application = new Application();
        $application->setName('NonExistingApplication');

        $requestBody = $this->getRequest($application, $user);
        $response = $this->sendPostRequest('UserApplication', 'Show', $requestBody);

        static::assertEquals(200, $response->getStatusCode());

        $xml = $response->getContent();
        $xmlElement = $this->loadResponse($xml);

        $xmlElementExpected = $this->loadXmlDomElement(
            __DIR__ . '/xml/response-structure-error.xml',
            'SsoResponse'
        );

        static::assertEqualXMLStructure(
            $xmlElementExpected,
            $xmlElement,
            false,
            $this->fXml($requestBody, $xml, 'Xml structure check failed')
        );

        // Value check
        $xmlSimple = simplexml_load_string($xml);

        static::assertEquals(
            Constants::STATUS_NOT_FOUND,
            (string)$xmlSimple->Status,
            $this->fXml($requestBody, $xml, 'Global xml status code does not match!')
        );

        static::assertRegExp(
            Constants::REGEXP_DATE,
            (string)$xmlSimple->Date,
            $this->fXml($requestBody, $xml, 'Date format does not match!')
        );

        static::assertEquals(
            Constants::STATUS_NOT_FOUND,
            (string)$xmlSimple->Errors->Error->Status,
            $this->fXml($requestBody, $xml, 'Xml status code does not match!')
        );

        static::assertEquals(
            'u001',
            (string)$xmlSimple->Errors->Error->ErrorCode,
            $this->fXml($requestBody, $xml, 'Error code does not match!')
        );
    }

    /**
     * @param Application $application
     * @param User $user
     * @return string
     */
    private function getRequest(Application $application, User $user)
    {
        return '<?xml version="1.0" encoding="UTF-8"?>
<SsoRequest>' . (string)(new Credentials($this->configuration)) . '
    <UserApplication>
        <Show>
            <Key>
                <UserType>
                    <Username>' . $this->cdata($user->getUsername()) . '</Username>
                </UserType>
                <ApplicationType>
                    <Active>' . ($application->isActive() ? '1' : '0') . '</Active>
                </ApplicationType>
            </Key>
        </Show>
    </UserApplication>
</SsoRequest>';
    }
}
