<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Tests\Functional\Services\Tests\Version2\UserSearch\FindByApplication;


use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Credentials;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version2\FunctionalTestCase;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version2\Model\Application;

/**
 * Class FindByApplicationTest
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Tests\Version2\UserSearch\FindByApplicationTest
 */
class ActiveFlagTest extends FunctionalTestCase
{
    public function testFindActiveUserWithoutSendingActiveFlag()
    {
        $application = $this->helperFactory->applicationAdd()->execute();
        $this->helperFactory->userPermissionAdd()->execute($application);

        $applicationAttribute = $this->helperFactory->applicationAttributeAdd()->execute($application);

        $user = $this->helperFactory->userAdd()->execute();

        $this->helperFactory->userApplicationAdd()->execute($user, $application);
        $this->helperFactory->userApplicationAttributeAdd()->execute($user, $application, $applicationAttribute);

        $requestBody = $this->getRequestWithoutActiveFlag($application);
        $response = $this->sendPostRequest('UserSearch', 'FindByApplication', $requestBody);

        static::assertEquals(200, $response->getStatusCode());

        $xml = $response->getContent();
        $xmlElement = $this->loadResponse($xml);

        $xmlElementExpected = $this->loadXmlDomElement(
            __DIR__ . '/xml/response-structure-success-single-user.xml',
            'SsoResponse'
        );

        static::assertEqualXMLStructure(
            $xmlElementExpected,
            $xmlElement,
            false,
            $this->fXml($requestBody, $xml, 'Xml structure check failed')
        );
    }

    public function testFindInactiveUserWithoutSendingActiveFlag()
    {
        $application = $this->helperFactory->applicationAdd()->execute();
        $this->helperFactory->userPermissionAdd()->execute($application);

        $applicationAttribute = $this->helperFactory->applicationAttributeAdd()->execute($application);

        $user = $this->helperFactory->userAdd()->execute();

        $this->helperFactory->userApplicationAdd()->execute($user, $application);
        $this->helperFactory->userApplicationAttributeAdd()->execute($user, $application, $applicationAttribute);

        $requestBody = $this->getRequestWithoutActiveFlag($application);
        $response = $this->sendPostRequest('UserSearch', 'FindByApplication', $requestBody);

        static::assertEquals(200, $response->getStatusCode());

        $xml = $response->getContent();
        $xmlElement = $this->loadResponse($xml);

        $xmlElementExpected = $this->loadXmlDomElement(
            __DIR__ . '/xml/response-structure-success-single-user.xml',
            'SsoResponse'
        );

        static::assertEqualXMLStructure(
            $xmlElementExpected,
            $xmlElement,
            false,
            $this->fXml($requestBody, $xml, 'Xml structure check failed')
        );
    }

    public function testFindActiveUserWithSendingActiveFlagActive()
    {
        $application = $this->helperFactory->applicationAdd()->execute();
        $this->helperFactory->userPermissionAdd()->execute($application);

        $applicationAttribute = $this->helperFactory->applicationAttributeAdd()->execute($application);

        $user = $this->helperFactory->userAdd()->execute();

        $this->helperFactory->userApplicationAdd()->execute($user, $this->getApplicationActive($application));
        $this->helperFactory->userApplicationAttributeAdd()->execute($user, $application, $applicationAttribute);

        $xmlRequest = $this->getRequestWithActiveFlag($this->getApplicationActive($application));
        $requestBody = $xmlRequest;
        $response = $this->sendPostRequest('UserSearch', 'FindByApplication', $requestBody);

        static::assertEquals(200, $response->getStatusCode());

        $xml = $response->getContent();
        $xmlElement = $this->loadResponse($xml);

        $xmlElementExpected = $this->loadXmlDomElement(
            __DIR__ . '/xml/response-structure-success-single-user.xml',
            'SsoResponse'
        );

        static::assertEqualXMLStructure(
            $xmlElementExpected,
            $xmlElement,
            false,
            $this->fXml($requestBody, $xml, 'Xml structure check failed')
        );
    }

    public function testFindActiveUserWithSendingActiveFlagInactive()
    {
        $application = $this->helperFactory->applicationAdd()->execute();
        $this->helperFactory->userPermissionAdd()->execute($application);

        $applicationAttribute = $this->helperFactory->applicationAttributeAdd()->execute($application);

        $user = $this->helperFactory->userAdd()->execute();

        $this->helperFactory->userApplicationAdd()->execute($user, $this->getApplicationActive($application));
        $this->helperFactory->userApplicationAttributeAdd()->execute($user, $application, $applicationAttribute);

        $requestBody = $this->getRequestWithActiveFlag($this->getApplicationInactive($application));
        $response = $this->sendPostRequest('UserSearch', 'FindByApplication', $requestBody);

        static::assertEquals(200, $response->getStatusCode());

        $xml = $response->getContent();
        $xmlElement = $this->loadResponse($xml);

        $xmlElementExpected = $this->loadXmlDomElement(
            __DIR__ . '/xml/response-structure-success-empty-result.xml',
            'SsoResponse'
        );

        static::assertEqualXMLStructure(
            $xmlElementExpected,
            $xmlElement,
            false,
            $this->fXml($requestBody, $xml, 'Xml structure check failed')
        );
    }

    public function testFindInactiveUserWithSendingActiveFlagInactive()
    {
        $application = $this->helperFactory->applicationAdd()->execute();
        $this->helperFactory->userPermissionAdd()->execute($application);

        $applicationAttribute = $this->helperFactory->applicationAttributeAdd()->execute($application);

        $user = $this->helperFactory->userAdd()->execute();

        $this->helperFactory->userApplicationAdd()->execute($user, $application);
        $this->helperFactory->userApplicationAttributeAdd()->execute($user, $application, $applicationAttribute);

        $requestBody = $this->getRequestWithActiveFlag($this->getApplicationInactive($application));
        $response = $this->sendPostRequest('UserSearch', 'FindByApplication', $requestBody);

        static::assertEquals(200, $response->getStatusCode());

        $xml = $response->getContent();
        $xmlElement = $this->loadResponse($xml);

        $xmlElementExpected = $this->loadXmlDomElement(
            __DIR__ . '/xml/response-structure-success-single-user.xml',
            'SsoResponse'
        );

        static::assertEqualXMLStructure(
            $xmlElementExpected,
            $xmlElement,
            false,
            $this->fXml($requestBody, $xml, 'Xml structure check failed')
        );
    }

    public function testFindInactiveUserWithSendingActiveFlagActive()
    {
        $application = $this->helperFactory->applicationAdd()->execute();
        $this->helperFactory->userPermissionAdd()->execute($application);

        $application->setActive(true);

        $applicationAttribute = $this->helperFactory->applicationAttributeAdd()->execute($application);

        $user = $this->helperFactory->userAdd()->execute();

        $this->helperFactory->userApplicationAdd()->execute($user, $this->getApplicationInactive($application));
        $this->helperFactory->userApplicationAttributeAdd()->execute($user, $application, $applicationAttribute);

        $requestBody = $this->getRequestWithActiveFlag($this->getApplicationActive($application));
        $response = $this->sendPostRequest('UserSearch', 'FindByApplication', $requestBody);

        static::assertEquals(200, $response->getStatusCode());

        $xml = $response->getContent();
        $xmlElement = $this->loadResponse($xml);

        $xmlElementExpected = $this->loadXmlDomElement(
            __DIR__ . '/xml/response-structure-success-empty-result.xml',
            'SsoResponse'
        );

        static::assertEqualXMLStructure(
            $xmlElementExpected,
            $xmlElement,
            false,
            $this->fXml($requestBody, $xml, 'Xml structure check failed')
        );
    }

    /**
     * @param Application $application
     * @return Application
     */
    private function getApplicationActive(Application $application)
    {
        $application = clone $application;
        $application->setActive(true);
        return $application;
    }

    /**
     * @param Application $application
     * @return Application
     */
    private function getApplicationInactive(Application $application)
    {
        $application = clone $application;
        $application->setActive(false);
        return $application;
    }

    /**
     * @param Application $application
     * @return string
     */
    private function getRequestWithoutActiveFlag(Application $application)
    {
        return '<?xml version="1.0" encoding="UTF-8"?>
<SsoRequest>' . (string)(new Credentials($this->configuration)) . '
    <UserSearch>
        <FindByApplication>
            <Key>
                <ApplicationType>
                    <Name>' . $this->cdata($application->getName()) . '</Name>
                </ApplicationType>
            </Key>
        </FindByApplication>
    </UserSearch>
</SsoRequest>';
    }

    /**
     * @param Application $application
     * @return string
     */
    private function getRequestWithActiveFlag(Application $application)
    {
        return '<?xml version="1.0" encoding="UTF-8"?>
<SsoRequest>' . (string)(new Credentials($this->configuration)) . '
    <UserSearch>
        <FindByApplication>
            <Key>
                <ApplicationType>
                    <Name>' . $this->cdata($application->getName()) . '</Name>
                    <Active>' . ($application->isActive() ? '1' : '0') . '</Active>
                </ApplicationType>
            </Key>
        </FindByApplication>
    </UserSearch>
</SsoRequest>';
    }
}
