<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Tests\Functional\Services\Tests\Version2\XmlStructure;

use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Credentials;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version2\FunctionalTestCase;


use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version2\Constants;

/**
 * Class XmlStructureTest
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Tests\Version2\XmlStructure
 */
class XmlStructureTest extends FunctionalTestCase
{

    public function testInvalidControllerInXml()
    {
        $requestBody = '<?xml version="1.0" encoding="UTF-8"?><SsoRequest>' . (string)(new Credentials($this->configuration)) . '</SsoRequest>';
        $response = $this->sendPostRequest('InvalidController', 'Show', $requestBody);

        // Status code check
        static::assertEquals(400, $response->getStatusCode());

        $xml = $response->getContent();
        $xmlElement = $this->loadResponse($xml);

        $xmlExpectedElement = $this->loadXmlDomElement(
            __DIR__ . '/xml/response-structure-error-invalid-controller-in-xml.xml',
            'SsoResponse'
        );

        static::assertEqualXMLStructure(
            $xmlExpectedElement,
            $xmlElement,
            false,
            $this->fXml($requestBody, $xml, 'Xml structure check failed')
        );

        // Value check
        $xmlSimple = simplexml_load_string($xml);

        static::assertEquals(
            Constants::STATUS_BAD_REQUEST,
            (string)$xmlSimple->Status,
            $this->fXml($requestBody, $xml, 'Global xml status code does not match!')
        );

        static::assertRegExp(
            Constants::REGEXP_DATE,
            (string)$xmlSimple->Date,
            $this->fXml($requestBody, $xml, 'Date format does not match!')
        );

    }

    /**
     * Currently this request produces a critical error (status: crit1)
     * but should return status x002
     */
    public function testInvalidActionInXml()
    {
        $requestBody = '<?xml version="1.0" encoding="UTF-8"?><SsoRequest>' . (string)(new Credentials($this->configuration)) . '<User /></SsoRequest>';
        $response = $this->sendPostRequest('User', 'InvalidAction', $requestBody);

        // Status code check
        static::assertEquals(400, $response->getStatusCode());

        $xml = $response->getContent();
        $xmlElement = $this->loadResponse($xml);

        $xmlExpectedElement = $this->loadXmlDomElement(
            __DIR__ . '/xml/response-structure-error-invalid-action-in-xml.xml',
            'SsoResponse'
        );

        static::assertEqualXMLStructure(
            $xmlExpectedElement,
            $xmlElement,
            false,
            $this->fXml($requestBody, $xml, 'Xml structure check failed')
        );

        // Value check
        $xmlSimple = simplexml_load_string($xml);

        static::assertEquals(
            Constants::STATUS_BAD_REQUEST,
            (string)$xmlSimple->Status,
            $this->fXml($requestBody, $xml, 'Global xml status code does not match!')
        );

        static::assertRegExp(
            Constants::REGEXP_DATE,
            (string)$xmlSimple->Date,
            $this->fXml($requestBody, $xml, 'Date format does not match!')
        );

        static::assertEquals(
            'fw002',
            (string)$xmlSimple->Errors->Error->ErrorCode,
            $this->fXml($requestBody, $xml, 'Error code does not match!')
        );
    }
}
