<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Tests\Services\User\Add\Request\Version2;

use Sso\WebserviceBundle\ErrorHandler\ErrorHandlerInterface;
use Sso\WebserviceBundle\Services\User\Add\Request\Version2\RequestParser;
use Sso\WebserviceBundle\Services\User\Add\RequestData\User as RequestDataUser;
use Sso\WebserviceBundle\Services\User\Add\RequestData\Factory as RequestDataFactory;
use JMS\Serializer\SerializerBuilder;
use InvalidArgumentException;
use JMS\Serializer\SerializerInterface;
use Symfony\Component\Validator\Validator\ValidatorInterface;
use Sso\WebserviceBundle\Api\Mapper\Index as AutoMapper;
use Symfony\Component\Validator\ValidatorBuilder;
use Sso\WebserviceBundle\Tests\Services\ServicesKernelTestCase;

/**
 * Class RequestParserTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\WebserviceBundle\Tests\Services\User\Show\Request\Version2
 */
class RequestParserTest extends ServicesKernelTestCase
{
    private $validServiceToken = 'V2030cOhc6Vttcxs6r6bmtdlc8Z1ryTN1TQ16pjivEcprZhye9e17ba7508a4358f99c8ba52ded0f70RnZDhDyKMXLEWobXI2ZOrJ7mXjcPJJNk7wxoAw8WUTk0IMYa';
    private $validServiceName = 'MyService';
    private $validUserIdentifier = '5e211de5c4aa76564fc5e3657a7946aab3e2dbe60a773117568b3e67a2223a2c6878e5d25ee70588b19728f010417388f590128beced60402c7b8036b725ba71';
    private $validUsername = 'test@example.com';
    private $validServiceCountryCode = 'DE';

    public function testParseSuccess()
    {

        $serializer = SerializerBuilder::create()->build();

        $factory = new RequestDataFactory();
        $autoMapper = new AutoMapper();
        $errorHandler = $this->createMock(ErrorHandlerInterface::class);
        $errorHandler
            ->expects(self::never())
            ->method('addError');

        $validator = $this->createMock(ValidatorInterface::class);

        $requestParser = new RequestParser(
            $serializer,
            $factory,
            $errorHandler,
            $validator,
            $autoMapper
        );

        /** @var RequestDataUser $model */
        $model = $requestParser->parse($this->generateSuccessXml());

        self::assertInstanceOf(RequestDataUser::class, $model);
    }

    public function testParseErrorWrongParamsXml()
    {

        $serializer = SerializerBuilder::create()->build();

        $factory = new RequestDataFactory();
        $autoMapper = new AutoMapper();
        $errorHandler = $this->createMock(ErrorHandlerInterface::class);
        $errorHandler
            ->method('addError')
            ->willReturn(true);

        //$validator->method('validate')->willReturn(false);

        $requestParser = new RequestParser(
            $serializer,
            $factory,
            $errorHandler,
            $this->validator,
            $autoMapper
        );

        /** @var RequestDataUser $model */
        $model = $requestParser->parse($this->generateErrorXml());

        self::assertInstanceOf(RequestDataUser::class, $model);
        // self::assertSame($identifier, $model->getIdentifier());
    }

    /**
     * @expectedException InvalidArgumentException
     */
    public function testParseErrorSerializer()
    {

        $mockSerializer = $this->createMock(SerializerInterface::class);
        $mockSerializer->method('deserialize')->willReturn('42');

        $factory = new RequestDataFactory();
        $autoMapper = new AutoMapper();
        $errorHandler = $this->createMock(ErrorHandlerInterface::class);
        $errorHandler
            ->expects(self::never())
            ->method('addError');

        $validator = $this->createMock(ValidatorInterface::class);

        $requestParser = new RequestParser(
            $mockSerializer,
            $factory,
            $errorHandler,
            $validator,
            $autoMapper
        );

        /** @var RequestDataUser $model */
        $model = $requestParser->parse($this->generateSuccessXml());
    }

    /**
     * @return string
     */
    private function generateSuccessXml()
    {
        return '<?xml version="1.0"?>
                    <SsoRequest>
                        <Credentials>
                            <ServiceProvider>
                                <ServiceToken>' . $this->validServiceToken . '</ServiceToken>
                                <ServiceName>' . $this->validServiceName . '</ServiceName>
                            </ServiceProvider>
                            <ServiceTrigger>
                                <Username>' . $this->validUsername . '</Username>
                                <UserIdentifier>' . $this->validUserIdentifier . '</UserIdentifier>
                            </ServiceTrigger>
                            <ServiceCountry>
                                <Code>' . $this->validServiceCountryCode . '</Code>
                            </ServiceCountry>
                        </Credentials>
                        <User>
                        <Add>
                            <Value>
                                <UserType>
                                    <Email><![CDATA['.$this->faker->email.']]></Email>
                                    <Username><![CDATA['.$this->faker->userName.']]></Username>
                                    <Firstname><![CDATA['.$this->faker->firstName.']]></Firstname>
                                    <Lastname><![CDATA['.$this->faker->lastName.']]></Lastname>
                                    <Password><![CDATA['.$this->faker->password().']]></Password>
                                    <Active>'.$this->faker->boolean.'</Active>
                                </UserType>
                            </Value>
                        </Add>
                    </User>
               </SsoRequest>';
    }

    /**
     * @return string
     */
    private function generateErrorXml()
    {
        return '<?xml version="1.0"?>
                    <SsoRequest>
                        <Credentials>
                            <ServiceProvider>
                                <ServiceToken>' . $this->validServiceToken . '</ServiceToken>
                                <ServiceName>' . $this->validServiceName . '</ServiceName>
                            </ServiceProvider>
                            <ServiceTrigger>
                                <Username>' . $this->validUsername . '</Username>
                                <UserIdentifier>' . $this->validUserIdentifier . '</UserIdentifier>
                            </ServiceTrigger>
                            <ServiceCountry>
                                <Code>' . $this->validServiceCountryCode . '</Code>
                            </ServiceCountry>
                        </Credentials>
                        <User>
                        <Add>
                            <Value>
                                <UserType>
                                    <Email>'.$this->faker->userName.'</Email>
                                    <Username>'.$this->faker->userName.'</Username>
                                    <Firstname>'.$this->faker->firstName.'</Firstname>
                                    <Lastname>'.$this->faker->lastName.'</Lastname>
                                    <Password>hansmeiser</Password>
                                    <Active>hansmeiser</Active>
                                </UserType>
                            </Value>
                        </Add>
                    </User>
               </SsoRequest>';
    }
}
