<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Tests\Services\User\ResetPassword\Response\Version2;

use Sso\WebserviceBundle\Api\ApiManagerInterface;
use Sso\WebserviceBundle\ErrorHandler\ErrorHandlerInterface;
use Sso\WebserviceBundle\Services\User\ResetPassword\ResponseData\ResetPassword as ResponseDataResetPassword;
use Sso\WebserviceBundle\Services\User\ResetPassword\Response\Version2\ResponseBuilder;
use Sso\WebserviceBundle\Services\User\ResetPassword\Response\Version2\Factory;
use Sso\WebserviceBundle\Api\Exception\Type\Api as ApiException;
use JMS\Serializer\SerializerBuilder;
use Sso\WebserviceBundle\Entity\Webservice\Type\User as UserModel;
use Symfony\Component\Validator\Validator\ValidatorInterface;

/**
 * Class ResponseBuilderTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\WebserviceBundle\Tests\Services\User\Show\Response\Version2
 */
class ResponseBuilderTest extends \PHPUnit\Framework\TestCase
{
    /**
     * @var ApiManagerInterface
     */
    private $apiManager;

    protected function setUp()
    {
        $this->apiManager = $this->createMock(ApiManagerInterface::class);
    }

    public function testSetResponseSuccess()
    {
        $message = hash('sha256', mt_rand());
        $status = hash('sha256', mt_rand());

        $user = new ResponseDataResetPassword();
        $user->setMessage($message);
        $user->setStatus($status);

        $responseBuilder = $this->factoryResponseBuilder();
        $responseBuilder->setResponse($user);

        self::assertAttributeEquals($user, 'responseData', $responseBuilder);
    }

    /**
     * @param array $userData
     */
    public function testBuildResponseSuccess()
    {
        // Overwrite track-id, because otherwise it will be in response xml
        ApiException::setTrackId('');

        $responseBuilder = $this->factoryResponseBuilder();
        $responseBuilder->setResponse(new ResponseDataResetPassword());
        $responseXml = $responseBuilder->build('xml');

        $successXML = $this->generateSuccessXml();

        $responseObject = simplexml_load_string($responseXml);
        $successObject = simplexml_load_string($successXML);

        $this->assertSame($responseObject->SsoResponse->Code, $successObject->SsoResponse->Code);
        $this->assertSame($responseObject->SsoResponse->Status, $successObject->SsoResponse->Status);
        $this->assertSame($responseObject->SsoResponse->Message, $successObject->SsoResponse->Message);
    }

    /**
     * @return ResponseBuilder
     */
    private function factoryResponseBuilder()
    {
        $serializer = SerializerBuilder::create()->build();
        $factory = new Factory($this->apiManager);
        $errorHandler = $this->createMock(ErrorHandlerInterface::class);
        return new ResponseBuilder($serializer, $factory, $errorHandler);
    }

    /**
     * @return string
     */
    private function generateSuccessXml()
    {
        return '<?xml version="1.0"?>
        <SsoResponse>
            <Code>200</Code>
            <Status>OK</Status>
            <Trackid></Trackid>
            <Date>'.(new \DateTime())->format('Y-m-d H:i:s').'</Date>
            <User>
                <ResetPassword>
                    <Status><![CDATA[Success]]></Status>
                    <Message><![CDATA[Password hast been updated]]></Message>
                </ResetPassword>
            </User>
        </SsoResponse>';
    }

    /**
     * @return UserModel
     */
    public function userDataProvider()
    {
        $validator = $this->createMock(ValidatorInterface::class);
        $faker = \Faker\Factory::create();
        $user = new UserModel($validator);
        $user->setGuid($faker->uuid);
        $user->setUsername($faker->userName);
        $user->setEmail($faker->email);
        $user->setFirstname($faker->firstName);
        $user->setLastname($faker->lastName);
        $user->setActive(1);
        $user->setDeleted(0);
        $user->setAuthId($faker->sha256);
        $user->setLdapSearchAttributes($faker->sha256);
        $user->setLdapSearchValue($faker->sha256);
        $user->setMfaEnabled(true);

        return $user;
    }
}
