<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Tests\Services\User\Show\ResponseData;

use Sso\WebserviceBundle\Api\ApiManagerInterface;
use Sso\WebserviceBundle\Services\User\Show\ResponseData\User as ResponseDataUser;
use Sso\WebserviceBundle\Entity\Webservice\Type\User as UserModel;
use Symfony\Component\Validator\Validator\ValidatorInterface;

/**
 * Class UserTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\WebserviceBundle\Tests\Services\User\Show\ResponseData
 */
class UserTest extends \PHPUnit\Framework\TestCase
{

    protected function setUp()
    {
        $this->apiManager = $this->createMock(ApiManagerInterface::class);
    }

    public function testCreateFromUserModelSuccess()
    {

        $userDTO = new ResponseDataUser();
        $userModel =  $this->userDataProvider();
        $userDTO = $userDTO->setFromUserModel($userModel);

        $this->assertSame($userDTO->getGuid(), $userModel->getGuid());
        $this->assertSame($userDTO->getUsername(), $userModel->getUsername());
        $this->assertSame($userDTO->getEmail(), $userModel->getEmail());
        $this->assertSame($userDTO->getFirstname(), $userModel->getFirstname());
        $this->assertSame($userDTO->getLastname(), $userModel->getLastname());
        $this->assertSame($userDTO->isActive(), $userModel->isActive());
        $this->assertSame($userDTO->isDeleted(), $userModel->getDeleted());
        $this->assertSame($userDTO->getAuthId(), $userModel->getAuthId());
        $this->assertSame($userDTO->getLdapSearchAttributes(), $userModel->getLdapSearchAttributes());
        $this->assertSame($userDTO->getLdapSearchValue(), $userModel->getLdapSearchValue());
        $this->assertSame($userDTO->isMfaEnabled(), $userModel->isMfaEnabled());
    }

    /**
     * @return UserModel
     */
    public function userDataProvider()
    {
        $validator = $this->createMock(ValidatorInterface::class);
        $faker = \Faker\Factory::create();
        $user = new UserModel($validator);
        $user->setGuid($faker->uuid);
        $user->setUsername($faker->userName);
        $user->setEmail($faker->email);
        $user->setFirstname($faker->firstName);
        $user->setLastname($faker->lastName);
        $user->setActive(true);
        $user->setDeleted(0);
        $user->setAuthId($faker->sha256);
        $user->setLdapSearchAttributes($faker->sha256);
        $user->setLdapSearchValue($faker->sha256);
        $user->setMfaEnabled(true);

        return $user;
    }
}
